/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "fb-prefs.h"
#include "fb-conf.h"
#include "prefs-thumbwin.h"

typedef struct _FbPrefsThumbWin
{
	GtkWidget *spin1;
	GtkWidget *spin2;
	GtkWidget *spin3;
	GtkWidget *check1;
	GtkWidget *entry1;

	gboolean changed;
} FbPrefsThumbWin;

static void cb_change_monitor(void);
static GtkWidget *prefs_thumbwin_new (void);
static void prefs_thumbwin_set_value (void);
static void prefs_thumbwin_apply(void);
static void prefs_thumbwin_destroy(void);

static FbPrefsFunc prefs_func = {
	create: prefs_thumbwin_new,
	apply: prefs_thumbwin_apply,
	destroy: prefs_thumbwin_destroy,
};

static FbPrefsThumbWin *prefs_ui;

static void
cb_change_monitor(void)
{
	prefs_ui->changed = TRUE;
}

static GtkWidget *
prefs_thumbwin_new(void)
{
	GtkWidget *main_vbox, *vbox, *hbox, *table, *frame, *align;
	GtkWidget *label;

	prefs_ui = g_new0(FbPrefsThumbWin, 1);

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);

	prefs_ui->check1 = gtk_check_button_new_with_label (_("Display thumbnail name"));
	g_signal_connect (G_OBJECT (prefs_ui->check1), "toggled",
			  G_CALLBACK (cb_change_monitor), NULL);
	gtk_box_pack_start (GTK_BOX (main_vbox), prefs_ui->check1, FALSE, FALSE, 0);
	gtk_widget_show (prefs_ui->check1);

	/* size */
	frame = gtk_frame_new (_("Thumbnail Size"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	table = gtk_table_new(2, 2, TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("Width :"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 0, 1,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	prefs_ui->spin1 = gtk_spin_button_new_with_range(20, 150, 1);
	g_signal_connect(G_OBJECT(prefs_ui->spin1), "value-changed",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), prefs_ui->spin1,
			 1, 2, 0, 1,
			 0, 0,
			 0, 0);
	gtk_widget_show(prefs_ui->spin1);

	label = gtk_label_new(_("Height :"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 1, 2,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	prefs_ui->spin2 = gtk_spin_button_new_with_range(20, 150, 1);
	g_signal_connect(G_OBJECT(prefs_ui->spin2), "value-changed",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), prefs_ui->spin2,
			 1, 2, 1, 2,
			 0, 0,
			 0, 0);
	gtk_widget_show(prefs_ui->spin2);
	/* spacing */
	frame = gtk_frame_new (_("Thumbnail Spacing"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

/* 	table = gtk_table_new(2, 1, TRUE); */
	table = gtk_table_new(1, 1, TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("Spacing :"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 0, 1,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	prefs_ui->spin3 = gtk_spin_button_new_with_range(0, 50, 1);
	g_signal_connect(G_OBJECT(prefs_ui->spin3), "value-changed",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), prefs_ui->spin3,
			 1, 2, 0, 1,
			 0, 0,
			 0, 0);
	gtk_widget_show(prefs_ui->spin3);

	/* specify background */
	frame = gtk_frame_new (_("Specify Backbround"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	align = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
	gtk_alignment_set_padding(GTK_ALIGNMENT(align), 0, 2, 2, 2);
	gtk_container_add(GTK_CONTAINER(frame), align);
	gtk_widget_show(align);

	prefs_ui->entry1 = gtk_entry_new ();
	g_signal_connect(G_OBJECT(prefs_ui->entry1), "key-release-event",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_container_add(GTK_CONTAINER(align), prefs_ui->entry1);
	gtk_widget_show(prefs_ui->entry1);

	prefs_ui->changed = FALSE;

	prefs_thumbwin_set_value ();

	return main_vbox;
}

static void
prefs_thumbwin_set_value (void)
{
	gboolean flag;
	gint val_i;
	gchar *str;

	fb_conf_get_value ("thumbnail width", &val_i, FB_CONF_TYPE_INT, "100");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs_ui->spin1), val_i);

	fb_conf_get_value ("thumbnail height", &val_i, FB_CONF_TYPE_INT, "100");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs_ui->spin2), val_i);

	fb_conf_get_value ("thumbnail spacing", &val_i, FB_CONF_TYPE_INT, "20");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs_ui->spin3), val_i);

	fb_conf_get_value ("show thumb name", &flag, FB_CONF_TYPE_BOOLEAN, "TRUE");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs_ui->check1), flag);

	fb_conf_get_value ("thumbwin background", &str, FB_CONF_TYPE_STRING, ICONDIR"/cork.png");
	if (str) {
		gtk_entry_set_text (GTK_ENTRY (prefs_ui->entry1), str);
		g_free (str);
	}
}

static void
prefs_thumbwin_apply(void)
{
	gboolean flag;
	gint val_i;
	gchar *str, *locale;

	if (! prefs_ui->changed) return;

	val_i = gtk_spin_button_get_value(GTK_SPIN_BUTTON(prefs_ui->spin1));
	fb_conf_set_value ("thumbnail width", &val_i, FB_CONF_TYPE_INT);

	val_i = gtk_spin_button_get_value(GTK_SPIN_BUTTON(prefs_ui->spin2));
	fb_conf_set_value ("thumbnail height", &val_i, FB_CONF_TYPE_INT);

	val_i = gtk_spin_button_get_value(GTK_SPIN_BUTTON(prefs_ui->spin3));
	fb_conf_set_value ("thumbnail spacing", &val_i, FB_CONF_TYPE_INT);

	flag = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prefs_ui->check1));
	fb_conf_set_value ("show thumb name", &flag, FB_CONF_TYPE_BOOLEAN);

	str = gtk_editable_get_chars (GTK_EDITABLE (prefs_ui->entry1), 0, -1);
	locale = g_locale_from_utf8 (str, -1, NULL, NULL, NULL);
	fb_conf_set_value ("thumbwin background", locale, FB_CONF_TYPE_STRING);
	g_free (str);
	g_free (locale);

	prefs_ui->changed = FALSE;
}

static void
prefs_thumbwin_destroy(void)
{
	g_free(prefs_ui);
}

FbPrefsFunc *
prefs_thumbwin_get_func(void)
{
	return &prefs_func;
}
