#ifndef INCLUDE_H_FWATCH
#define INCLUDE_H_FWATCH

#include "WatchTaskGroup.hpp"

#include "tstring.hpp"
#include "ResourceAccessor.hpp"

#include <memory>

typedef std::auto_ptr<class FWatchApp> FWatchAppPtr;

class FWatchApp : public ResourceAccessor {
private:
	FWatchApp( const FWatchApp& ); //<! Ȃ
	operator=(const FWatchApp& ); //<! Ȃ

	FWatchApp( HINSTANCE v_hInstance, const tstring& v_applicationName, const tstring& v_helpFile, const tstring& v_iniFile, const tstring& v_infFile );

public:
	virtual ~FWatchApp();
	
	int run();

	virtual LPCTSTR getApplicationName() const;
	virtual HWND getMainHWnd() const;

	const tstring& getInfPath() const;
	const tstring& getIniPath() const;

	int showMessageBox( UINT uType, LPCTSTR caption, UINT uMessageID, ... ) const;

	void showHelp( HWND hWnd ) const;

	WatchTaskGroup& getCL();

	static FWatchAppPtr createFWatchApp() throw();

private:
	tstring applicationName_;
	HWND hMainWnd_;
	tstring helpFile_;
	tstring iniPath_;
	tstring infPath_;

	WatchTaskGroup cl_;
};

extern FWatchApp* pApp;

#endif

