#ifndef INCLUDE_H_WATCHTASK
#define INCLUDE_H_WATCHTASK

#include "SettingInfo.hpp"

#include "tstring.hpp"
#include <map>
#include <list>

#include "FileInfo.hpp"

#include "ActionInvoker.hpp"
#include "PatternMatch.hpp"
#include "Task.hpp"

#include "DirWatchObject.hpp"
#include "DelaySignal.hpp"
#include "PassiveTimer.hpp"

class WatchTask : public Task
{
private:
	WatchTask( const WatchTask& ); //<! Ȃ
	operator=( const WatchTask& ); //<! Ȃ

public:
	WatchTask( const CSettingInfo& v_settingInfo );

	virtual ~WatchTask();

	const CSettingInfo& getSettingInfo() const;

private:

	virtual void onThreadBinded();

	virtual void onThreadUnbinded();

	virtual void onThreadSignal();

	virtual void onThreadTick();

	virtual HANDLE getWaitableHandle();

	void prepareDeleteEntries();

	void sweepDeletedEntries();

	void EnumFile(const bool v_enableEvent );

	bool EnumFileRecursive( const tstring& v_baseDir, const int v_depth, const bool v_enableEvent );

	static bool getFileSize( const tstring& v_path, DWORD* v_pSizeLow, DWORD* v_pSizeHi = NULL );

private:
	DirWatchObject dirChangeNotification_;
	
	DelaySignal enumerationSignal_;
	
	PassiveTimer forceEnumerationTimer_;

	PassiveTimer garbageCollectTimer_;

	typedef std::map<tstring, FileInfo > FileInfoMap;

	FileInfoMap fileInfoMap_;

	typedef std::list<tstring> FileNameList;

	FileNameList deletePendingList_;

	PatternMatchCollection nameFilter_;

	ActionInvokerPtr pActionInvoker_;

	const FileTimeComparator fileTimeComparator_;

	CSettingInfo settingInfo_;
};


#endif
