// UnitTest.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.hpp"

#include <assert.h>
#include <vector>
#include <iterator>

#include <process.h>

#include "..\FWatch\Utility.hpp"
#include "..\FWatch\\tstringUty.hpp"
#include "..\FWatch\StringExpander.hpp"
#include "..\FWatch\SplitPath.hpp"
#include "..\FWatch\PatternMatch.hpp"
#include "..\FWatch\Task.hpp"

void testPropertyStringExpander();
void testIsMatch();
void testSplitPath();
void testEnsureEndsWith();
void testPatternMatch();
void testSplit();
void testSplitArgs();
void testMultiTask();
void testMultiTaskEx();

int _tmain(int argc, _TCHAR* argv[])
{
	DEBUGBLOCK(
		_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
	);

	testPropertyStringExpander();
	testIsMatch();
	testSplitPath();
	testEnsureEndsWith();
	testPatternMatch();
	testSplit();
	testSplitArgs();
	testMultiTask();
	testMultiTaskEx();

	return 0;
}

void testSplitArgs()
{
	std::vector< tstring > buf;
	splitArgs( _TEXT(" -flag \"absolute file name\" single  \"\"\"file\"\"\" \"\" n\"\"ame "), std::back_insert_iterator<std::vector<tstring> >( buf ) );
	std::vector< tstring >::iterator ite = buf.begin();

	assert( *ite++ == _TEXT("-flag") );
	assert( *ite++ == _TEXT("absolute file name") );
	assert( *ite++ == _TEXT("single") );
	assert( *ite++ == _TEXT("\"file\"") );
	assert( *ite++ == _TEXT("") );
	assert( *ite++ == _TEXT("name") );

	assert( ite == buf.end() );
}

void testSplit()
{
	std::vector< tstring > buf;
	split( _TEXT("hello|world||abc|"), '|', std::back_insert_iterator<std::vector<tstring> >(buf) );

	std::vector<tstring>::iterator ite = buf.begin();

	assert( *ite++ == _TEXT("hello") );
	assert( *ite++ == _TEXT("world") );
	assert( *ite++ == _TEXT("") );
	assert( *ite++ == _TEXT("abc") );
	assert( *ite++ == _TEXT("") );

	assert( ite == buf.end() );
}


void testPropertyStringExpander()
{
	// eXgp^[

	PropertyStringExpander expander;
	expander.addProperty( _TEXT("ABC"), _TEXT("123") );
	
	assert( expander.expandString( _TEXT("") ) == _TEXT("") );
	assert( expander.expandString( _TEXT("123 456") ) == _TEXT("123 456") );
	assert( expander.expandString( _TEXT("%ABC%") ) == _TEXT("123") );
	assert( expander.expandString( _TEXT("%abc%") ) == _TEXT("123") );
	assert( expander.expandString( _TEXT("%DEF%") ) == _TEXT("%DEF%") );
	assert( expander.expandString( _TEXT("%%ABC%%") ) == _TEXT("%123%") );
	assert( expander.expandString( _TEXT("%%DEF%%") ) == _TEXT("%%DEF%%") );
	assert( expander.expandString( _TEXT("%ABC%%%DEF%%") ) == _TEXT("123%%DEF%%") );
	assert( expander.expandString( _TEXT("%ABC%% %DEF%%") ) == _TEXT("123% %DEF%%") );
	assert( expander.expandString( _TEXT("%ABC%% %DEF%% ") ) == _TEXT("123% %DEF%% ") );

	assert( expander.expandString( _TEXT("%1 %2 %* -path=\"%ABC%\"" )) == _TEXT("%1 %2 %* -path=\"123\"") );
}

void testIsMatch()
{
	// eXgp^[

	assert( IsMatch( _TEXT(""), _TEXT("") ) );
	assert( ! IsMatch( _TEXT(""), _TEXT("?") ) );
	assert( IsMatch( _TEXT(""), _TEXT("*") ) );

	assert( IsMatch( _TEXT("A"), _TEXT("A") ) );
	assert( IsMatch( _TEXT("A"), _TEXT("?") ) );
	assert( IsMatch( _TEXT("AB"), _TEXT("?B") ) );
	assert( IsMatch( _TEXT("AB"), _TEXT("A?") ) );
	assert( ! IsMatch( _TEXT("AB"), _TEXT("??B") ) );
	assert( ! IsMatch( _TEXT("AB"), _TEXT("A?C") ) );

	assert( IsMatch( _TEXT("ABC"), _TEXT("ABC") ) );
	assert( IsMatch( _TEXT("ABC"), _TEXT("ABC*") ) );
	assert( IsMatch( _TEXT("ABCD"), _TEXT("ABC*") ) );
	assert( IsMatch( _TEXT("ABCABC"), _TEXT("ABC*") ) );

	assert( IsMatch( _TEXT("ABC ABC"), _TEXT("ABC*") ) );
	assert( IsMatch( _TEXT("ABC DEF"), _TEXT("ABC*DEF") ) );
	assert( IsMatch( _TEXT("ABC DEF DEF"), _TEXT("ABC*DEF") ) );
	assert( IsMatch( _TEXT("ABC"), _TEXT("*ABC") ) );
	assert( IsMatch( _TEXT("DEFABC"), _TEXT("*ABC") ) );
	assert( IsMatch( _TEXT("ABCDEFABC"), _TEXT("*DEF*") ) );
	assert( IsMatch( _TEXT("ABCDABC"), _TEXT("*ABC") ) );

	assert( ! IsMatch( _TEXT("ABCDABCD"), _TEXT("*ABC") ) );

	assert( IsMatch( _TEXT("a.txt"), _TEXT("*.txt") ) );
	assert( IsMatch( _TEXT("a.b.txt"), _TEXT("*.txt") ) );
	assert( IsMatch( _TEXT("a.b.txt"), _TEXT("*.b.*") ) );

	assert( ! IsMatch( _TEXT("a.txt.bin"), _TEXT("*.txt") ) );
	assert( ! IsMatch( _TEXT("a.txtx"), _TEXT("*.txt") ) );
	assert( ! IsMatch( _TEXT("a.c.d"), _TEXT("*.b.*") ) );

	assert( ! IsMatch( _TEXT("\"), _TEXT("?\\*") ) );
	assert( ! IsMatch( _TEXT("\"), _TEXT("*\\*") ) );
	assert( ! IsMatch( _TEXT("\\"), _TEXT("?\\*") ) );
	assert( ! IsMatch( _TEXT("\\"), _TEXT("*\\*") ) );
	assert( IsMatch( _TEXT("\\\\"), _TEXT("?\\*") ) );
	assert( IsMatch( _TEXT("\\\\"), _TEXT("*\\\\") ) );
}

void testSplitPath()
{
	SplitPath splitPath;

	assert( splitPath.getPath().empty() );
	assert( splitPath.getDirectory().empty() );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setPath( _TEXT("abc") );
	assert( splitPath.getPath() == _TEXT("abc") );
	assert( splitPath.getDirectory().empty() );
	assert( splitPath.getFile() == _TEXT("abc") );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension() == _TEXT("abc") );

	splitPath.setPath( _TEXT("C:\\abc\\") );
	assert( splitPath.getPath() == _TEXT("C:\\abc\\") );
	assert( splitPath.getDirectory() == _TEXT("C:\\abc\\") );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setPath( _TEXT("\\\\HOST\\abc\\") );
	assert( splitPath.getPath() == _TEXT("\\\\HOST\\abc\\") );
	assert( splitPath.getDirectory() == _TEXT("\\\\HOST\\abc\\") );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setDirectory( _TEXT("D:\\xyz") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile().empty() );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension().empty() );

	splitPath.setFile( _TEXT("test") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\test") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile() == _TEXT("test") );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension() == _TEXT("test") );

	splitPath.setFile( _TEXT("test2.") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\test2") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile() == _TEXT("test2") );
	assert( splitPath.getFileExtension().empty() );
	assert( splitPath.getFileNoExtension() == _TEXT("test2") );

	splitPath.setFile( _TEXT("test3.txt") );
	assert( splitPath.getPath() == _TEXT("D:\\xyz\\test3.txt") );
	assert( splitPath.getDirectory() == _TEXT("D:\\xyz\\") );
	assert( splitPath.getFile() == _TEXT("test3.txt") );
	assert( splitPath.getFileExtension() == _TEXT("txt") );
	assert( splitPath.getFileNoExtension() == _TEXT("test3") );

	splitPath.setPath( _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test4.dat") );
	assert( splitPath.getPath() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test4.dat") );
	assert( splitPath.getDirectory() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test4.dat") );
	assert( splitPath.getFileExtension() == _TEXT("dat") );
	assert( splitPath.getFileNoExtension() == _TEXT("test4") );

	splitPath.setPath( _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test5.dat.txt") );
	assert( splitPath.getPath() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\test5.dat.txt") );
	assert( splitPath.getDirectory() == _TEXT("D:\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test5.dat.txt") );
	assert( splitPath.getFileExtension() == _TEXT("txt") );
	assert( splitPath.getFileNoExtension() == _TEXT("test5.dat") );

	splitPath.setPath( _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\test6.dat.txt") );
	assert( splitPath.getPath() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\test6.dat.txt") );
	assert( splitPath.getDirectory() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test6.dat.txt") );
	assert( splitPath.getFileExtension() == _TEXT("txt") );
	assert( splitPath.getFileNoExtension() == _TEXT("test6.dat") );

	splitPath.setFileExtension( _TEXT("hlp") );
	assert( splitPath.getPath() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\test6.dat.hlp") );
	assert( splitPath.getDirectory() == _TEXT("\\\\HOST\\ABC.TXT\\DEF.XYZ\\") );
	assert( splitPath.getFile() == _TEXT("test6.dat.hlp") );
	assert( splitPath.getFileExtension() == _TEXT("hlp") );
	assert( splitPath.getFileNoExtension() == _TEXT("test6.dat") );

}

void testEnsureEndsWith()
{
	assert( tstringuty::getCharCount( _TEXT("" ) ) == 0 );
	assert( tstringuty::getCharCount( _TEXT("A" ) ) == 1 );
	assert( tstringuty::getCharCount( _TEXT("AA" ) ) == 2 );
	assert( tstringuty::getCharCount( _TEXT("AA\" ) ) == 3 );
	assert( tstringuty::getCharCount( _TEXT("\\" ) ) == 2 );
	assert( tstringuty::getCharCount( _TEXT("\A\" ) ) == 3 );
	assert( tstringuty::getCharCount( _TEXT("\A\A" ) ) == 4 );
	assert( tstringuty::getCharCount( _TEXT("A\\A\\A" ) ) == 7 );

	assert( tstringuty::ensureEndsWith( _TEXT(""), _TEXT("\\") ) == _TEXT("\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("\\"), _TEXT("\\") ) == _TEXT("\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("ABC"), _TEXT("\\") ) == _TEXT("ABC\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("ABC\\"), _TEXT("\\") ) == _TEXT("ABC\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("\"), _TEXT("\\") ) == _TEXT("\\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("\\\"), _TEXT("\\") ) == _TEXT("\\\") );
}

void testPatternMatch()
{
	PatternMatchCollection patterns1( true ); // ׂă}b`OK
	assert( patterns1.isMatch( _TEXT("any") ) );
	
	patterns1.addPattern( SimplePatternMatch( _TEXT("*.txt") ) );
	assert( patterns1.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.dat") ) );

	patterns1.addPattern( SimplePatternMatch( _TEXT("*123.txt") ) );
	assert( patterns1.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.dat") ) );

	patterns1.addPattern( SimplePatternMatch( _TEXT("*123.dat") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns1.isMatch( _TEXT("abc123.dat") ) );

	PatternMatchCollection patterns2( false ); // 1ł}b`OK
	assert( ! patterns2.isMatch( _TEXT("any") ) );
	
	patterns2.addPattern( SimplePatternMatch( _TEXT("*.txt") ) );
	assert( patterns2.isMatch( _TEXT("abc123.txt") ) );
	assert( ! patterns2.isMatch( _TEXT("abc123.dat") ) );

	patterns2.addPattern( SimplePatternMatch( _TEXT("*123.dat") ) );
	assert( patterns2.isMatch( _TEXT("abc123.txt") ) );
	assert( patterns2.isMatch( _TEXT("abc123.dat") ) );

}

class TestTask : public Task
{
public:

	TestTask( const tstring& v_name, bool v_enableHandle )
		: name_( v_name )
		, hEvent_( NULL )
		, nInitialized_ ( 0 )
		, nExited_( 0 )
	{
		if( v_enableHandle ) {
			hEvent_ = ::CreateEvent( NULL, FALSE, FALSE, NULL );
		}
	}

	virtual ~TestTask()
	{
		if( hEvent_ != NULL ) {
			::CloseHandle( hEvent_ );
		}
		assert( ( nInitialized_ == 0 || nExited_ != 0 ) && "jR[obN܂B" );
	}

	virtual void onThreadBinded()
	{
		//_tprintf( _TEXT("thread#onThreadInit %s\n"), name_.c_str() );
		nInitialized_++;
	}

	virtual void onThreadUnbinded()
	{
		assert( nInitialized_ != 0 && "R[obN܂B" );
		//_tprintf( _TEXT("thread#onThreadExit %s\n"), name_.c_str() );
		nExited_++;
	}

	virtual void onThreadSignal()
	{
		assert( nInitialized_ != 0 && "R[obN܂B" );
		//_tprintf( _TEXT("thread#onThreadSignal %s\n"), name_.c_str() );
	}

	virtual void onThreadTick()
	{
		assert( nInitialized_ != 0 && "R[obN܂B" );
		//_tprintf( _TEXT("thread#onThreadTick %s\n"), name_.c_str() );
	}

	void pulseEvent()
	{
		if( hEvent_ != NULL ) {
			::PulseEvent( hEvent_ );
		}
	}

	HANDLE getWaitableHandle()
	{
		return hEvent_;
	}

	int nInitialized_;
	int nExited_;
	HANDLE hEvent_;
	const tstring name_;
};

void testMultiTask()
{
	const DWORD waitTimeBase = 60;
	BasicMultiTask taskGroup( waitTimeBase / 2 );
	
	typedef std::vector<Task*> TaskList;
	TaskList taskList;
	
	const int maxtask = 60;
	for( int idx=0; idx<maxtask; idx++ ) {
		TCHAR buf[256];
		_stprintf( buf, _TEXT("No.%d"), idx );
		Task* pTask = new TestTask( buf, true );
		taskList.push_back( pTask );
		const bool result = taskGroup.appendTask( pTask, false );
		assert( result && "o^ɎsĂ܂B" );
	}
	assert( taskGroup.size() == maxtask && "^XNo^v܂B" );

	taskGroup.startSchedule();

	Sleep( waitTimeBase * 3 );

	taskGroup.stopSchedule();
	taskGroup.startSchedule();

	Sleep( waitTimeBase * 3 );

	const DWORD st = ::GetTickCount();
	int count = 0;
	int addcount = 0;
	while( ! taskList.empty() ) {
		TaskList::iterator ite = taskList.begin();
		TestTask* pTask = dynamic_cast<TestTask*>( *ite );
		assert( pTask->nInitialized_ != 0 && "܂Ă܂B" );
		assert( pTask->nInitialized_ == 2 && "JnCxgsł" );
		assert( pTask->nExited_ == 1 && "ICxgsł" );
		
		const bool result = taskGroup.removeTask( pTask );
		assert( result && "폜ɎsĂ܂B" );

		assert( pTask->nExited_ == 2 && "ICxgsł" );
		delete pTask;
		ite =taskList.erase( ite );

		while( ite != taskList.end() ) {
			TestTask* pTestTask = dynamic_cast<TestTask*>( *ite );
			pTestTask->pulseEvent();
			++ite;
		}

		if( ( count % 3 ) == 0 ) {
			TCHAR buf[256];
			_stprintf( buf, _TEXT("AddTask No.%d"), addcount++ );
			Task* pTask = new TestTask( buf, ( count % 5 ) == 0 );
			taskGroup.appendTask( pTask, true ); // taskListɒǉĂȂƂɒӁB
		}
		count++;
		::Sleep( waitTimeBase );
	}
	const DWORD en = ::GetTickCount();
	const DWORD span = (en - st);
	assert( span < (DWORD)( count * waitTimeBase + 1000 ) && "Ԃ肷łB" );
	assert( taskGroup.size() == addcount && "^XNco^v܂B" );

	taskGroup.resetSchedule();
}

void testMultiTaskEx()
{
	const DWORD waitTimeBase = 60;
	BasicMultiTaskEx taskGroup( waitTimeBase / 2 );

	typedef std::vector<Task*> TaskList;
	TaskList taskList;

	const int mx = 300;
	for( int idx=0; idx<mx; idx++ ) {
		TestTask* pTask = new TestTask( _TEXT("testtask"), false );
		taskList.push_back( pTask );
		const bool result = taskGroup.appendTask( pTask, false );
		assert( result && "o^ɎsĂ܂B" );
	}
	assert( taskGroup.size() == mx && "^XN̐v܂B" );

	taskGroup.startSchedule();
	::Sleep( waitTimeBase * 3 );
	taskGroup.resetSchedule();
	assert( taskGroup.size() == 0 && "^XN̐słB" );

	for( TaskList::iterator ite_taskList = taskList.begin();
		ite_taskList != taskList.end();
		++ite_taskList )
	{
		TestTask* pTask = dynamic_cast<TestTask*>( *ite_taskList );
		assert( pTask->nInitialized_ == 1 && "JnĂ܂B" );
		assert( pTask->nExited_ == 1 && "IĂ܂B" );
		delete pTask;
	}
	taskList.clear();
}

