#include "stdafx.hpp"

#include "ActionInvoker.hpp"

#include <vector>

#include <assert.h>

#include "StringExpander.hpp"
#include "SplitPath.hpp"

ActionInvoker::ActionInvoker( const CSettingInfo& v_settingInfo ) throw()
	: settingInfo_( v_settingInfo )
{
}

ActionInvoker::~ActionInvoker() throw()
{
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end();
		++ite )
	{
		HANDLE hProcess = *ite;
		::CloseHandle( hProcess );
	}
	processHandleList_.clear();
}

unsigned int ActionInvoker::sweepTerminatedProcess() throw()
{
	unsigned int count = 0;
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end(); )
	{
		HANDLE hProcess = *ite;
		const DWORD ret = ::WaitForSingleObject( hProcess, 0 );
		if( ret != WAIT_TIMEOUT ) {
			// vZXIĂȂƂmłȂΏIĂƂ݂ȂB
			::CloseHandle( hProcess );
			ite = processHandleList_.erase( ite );
		}
		else {
			count++;
			++ite;
		}
	}
	return count;
}

void ActionInvoker::addTraceProcessHandle( HANDLE v_hProcess ) throw()
{
	if( v_hProcess == NULL ) {
		return;
	}
	if( settingInfo_.getMaxProcess() <= 0 ) {
		// Ȃ̂ŒǐՂ̕KvȂ
		::CloseHandle( v_hProcess );
	}
	else {
		processHandleList_.push_back( v_hProcess );
	}
}

//////////

ActionInvokerFactory::ActionInvokerFactory( const CSettingInfo& v_settingInfo )
	: settingInfo_( v_settingInfo )
{
}

ActionInvokerFactory::~ActionInvokerFactory()
{
}

ActionInvokerPtr ActionInvokerFactory::create() const
{
	return ActionInvokerPtr( new ShellExecActionInvoker( settingInfo_ ) );
}

//////////


ShellExecActionInvoker::ShellExecActionInvoker( const CSettingInfo& v_settingInfo ) throw()
	: ActionInvoker( v_settingInfo )
{
}

ShellExecActionInvoker::~ShellExecActionInvoker() throw()
{
}

bool ShellExecActionInvoker::createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw()
{
	//required:
	assert( ! v_absolutePath.empty() && "v_absolutePathɋ͎wł܂B" );
	
	//do:
	// sp[^̍쐬
	if( settingInfo_.getAppName().empty() || settingInfo_.getAction().empty() ){
		return true;
	}

	// sp[^̃Zbg

	SplitPath splitPath( v_absolutePath );	

	PropertyStringExpander expander;
	expander.addProperty( _TEXT("PATH"), v_absolutePath );
	expander.addProperty( _TEXT("DIR"), splitPath.getDirectory() );
	expander.addProperty( _TEXT("NAME"), splitPath.getFile() );
	expander.addProperty( _TEXT("NAMEBODY"), splitPath.getDirectory() );
	expander.addProperty( _TEXT("EXTENSION"), splitPath.getFileExtension() );

//			{"count",strCount},
//			{"spath",strShortName},
//			{"date",strDate},
//			{"time",strTime},
//			{"sdir",strShortDir},

	const tstring appName = expander.expandString( settingInfo_.getAppName() );
	const tstring param = expander.expandString( settingInfo_.getParam() );
	const tstring verb = expander.expandString( settingInfo_.getAction() );
	const tstring appCurrentDir = expander.expandString( settingInfo_.getAppCurrentDir() );

	SHELLEXECUTEINFO execinfo = {0};
	execinfo.cbSize = sizeof(SHELLEXECUTEINFO);
	execinfo.fMask  = SEE_MASK_CONNECTNETDRV | SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS;
	execinfo.hwnd   = NULL; //TODO: SHellhWnd
	execinfo.lpDirectory  = appCurrentDir.c_str();
	execinfo.nShow = settingInfo_.getShowWindow().getShowCommand();
	execinfo.lpVerb = verb.c_str();
	execinfo.lpFile = appName.c_str();
	execinfo.lpParameters = param.c_str();

	// s
	DWORD err = ERROR_SUCCESS;
	if( ShellExecuteEx( &execinfo ) ) {
		addTraceProcessHandle( execinfo.hProcess );
	}
	else {
		err = GetLastError();
	}

	return err == ERROR_SUCCESS;
}

