#ifndef INCLUDE_H_ACTIONINVOKER
#define INCLUDE_H_ACTIONINVOKER

#include "FileInfo.hpp"
#include "SettingInfo.hpp"

#include "tstring.hpp"
#include <list>
#include <memory>

class ActionInvoker {
private:
	ActionInvoker( const ActionInvoker& ); //<! Ȃ
	operator=( const ActionInvoker& ); //<! Ȃ
public:
	ActionInvoker( const CSettingInfo& v_settingInfo ) throw();
	
	virtual ~ActionInvoker() throw();

	virtual bool createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw() = 0;

	unsigned int sweepTerminatedProcess() throw();

protected:

	void addTraceProcessHandle( HANDLE v_hProcess ) throw();

	const CSettingInfo& settingInfo_;

private:

	typedef std::list<HANDLE> ProcessHandleList;

	ProcessHandleList processHandleList_;

};
typedef std::auto_ptr<ActionInvoker> ActionInvokerPtr;

class ActionInvokerFactory {
private:
	ActionInvokerFactory( const ActionInvokerFactory& ); //<! Ȃ
	operator=( const ActionInvokerFactory& ); //<! Ȃ

public:
	ActionInvokerFactory( const CSettingInfo& v_settingInfo );
	virtual ~ActionInvokerFactory();
	virtual ActionInvokerPtr create() const;

private:
	const CSettingInfo& settingInfo_;
};

class ShellExecActionInvoker : public ActionInvoker {
private:
	ShellExecActionInvoker( const &ShellExecActionInvoker ); //<! Ȃ
	operator=( const ShellExecActionInvoker& ); //<! Ȃ

public:
	ShellExecActionInvoker( const CSettingInfo& v_settingInfo ) throw();

	virtual ~ShellExecActionInvoker() throw();

	virtual bool createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw();
};

#endif
