#include "stdafx.hpp"

#include "FileInfo.hpp"

FileInfo::FileInfo( const WIN32_FIND_DATA& v_finddata, bool v_modified, bool v_exists )
	: writetime_( v_finddata.ftLastWriteTime )
	, size_( v_finddata.nFileSizeLow )
	, bExist_( v_exists )
	, detectModified_( v_modified )
	, tickcount_( 0 )
	, deletePending_( false )
	, deleteBeginTickCount_( 0 )
{
}

FileInfo::FileInfo( const FileInfo& v_other )
	: writetime_( v_other.writetime_ )
	, bExist_( v_other.bExist_ )
	, detectModified_( v_other.detectModified_ )
	, tickcount_( v_other.tickcount_ )
	, size_( v_other.size_ )
	, deletePending_( v_other.deletePending_ )
	, deleteBeginTickCount_( v_other.deleteBeginTickCount_ )
{
}

FileInfo& FileInfo::operator=( const FileInfo& v_other )
{
	if( this == &v_other ) {
		return *this;
	}

	writetime_ = v_other.writetime_;
	bExist_ = v_other.bExist_;
	detectModified_ = v_other.detectModified_;
	tickcount_ = v_other.tickcount_;
	size_ = v_other.size_;
	deletePending_ = v_other.deletePending_;
	deleteBeginTickCount_ = v_other.deleteBeginTickCount_;

	return *this;
}

FileInfo::~FileInfo()
{
}

void FileInfo::update( const WIN32_FIND_DATA& v_finddata )
{
	writetime_ = v_finddata.ftLastWriteTime;
	size_ = v_finddata.nFileSizeLow;
}

void FileInfo::setExist( bool v_exist )
{
	bExist_ = v_exist;
}

void FileInfo::setDeletePending( bool v_deletePending ) 
{
	deletePending_ = v_deletePending;
}

void FileInfo::setDeleteBeginTickCount( DWORD v_tickcount )
{
	deleteBeginTickCount_ = v_tickcount;
}

void FileInfo::setDetectModified( bool v_detectModified )
{
	detectModified_ = v_detectModified;
}

void FileInfo::setLastModified( const FILETIME& v_filetime )
{
	writetime_ = v_filetime;
}

void FileInfo::setCountdownTickCount( DWORD v_tickcount )
{
	tickcount_ = v_tickcount;
}

void FileInfo::setSize( DWORD v_size )
{
	size_ = v_size;
}
