#include "stdafx.hpp"

#include "PassiveTimer.hpp"

#include <assert.h>

PassiveTimer::PassiveTimer( int v_span, DWORD v_tick, bool v_enabled )
	: enabled_( v_enabled )
	, span_ ( v_span )
	, tick_ ( v_tick )
{
	assert( v_span >= 0 && "v_spanɕ̒l͎wł܂B" );
}

PassiveTimer::~PassiveTimer()
{
}

bool PassiveTimer::isSignaled( DWORD v_tick ) const
{
	return enabled_ && ( ( span_ == 0 ) || ( ( v_tick - tick_ ) > (DWORD) span_ ) );
}

void PassiveTimer::reset( DWORD v_tick, bool v_enabled )
{
	enabled_ = v_enabled;
	tick_ = v_tick;
}

int PassiveTimer::getSpan() const
{
	return span_;
}

bool PassiveTimer::isEnabled() const
{
	return enabled_;
}

