#include "stdafx.hpp"

#include <assert.h>

#include <string>

#include "SAXContentHandlerAdaptor.hpp"

#include "tstringUty.hpp"


SAXAttributesAdaptor::SAXAttributesAdaptor( ISAXAttributes* v_source )
	: source_( v_source )
{
	assert( v_source != NULL && "v_sourcenull͎wł܂B" );
	source_->AddRef();
}

SAXAttributesAdaptor::~SAXAttributesAdaptor()
{
	source_->Release();
}

int SAXAttributesAdaptor::getLength() const
{
	int len = 0;
	const HRESULT hr = source_->getLength( &len );
	assert( SUCCEEDED( hr ) && "G[" );
	return len;
}

tstring SAXAttributesAdaptor::getURI(int v_index ) const
{
	const wchar_t* uri = NULL;
	int len = 0;

	if( SUCCEEDED( source_->getURI( v_index, &uri, &len ) ) ) {
		const std::wstring tmp( uri, len );
		return tstringuty::getTString( tmp );
	}
	assert( false && "sAG[" );
	return _TEXT("");
}

tstring SAXAttributesAdaptor::getLocalName(int v_index ) const
{
	const wchar_t* localName = NULL;
	int len = 0;
	if( SUCCEEDED( source_->getLocalName( v_index, &localName, &len ) ) ) {
		const std::wstring tmp( localName, len );
		return tstringuty::getTString( tmp );
	}
	assert( false && "sAG[" );
	return _TEXT("");
}

tstring SAXAttributesAdaptor::getQName(int v_index ) const
{
	const wchar_t* qName = NULL;
	int len = 0;
	if( SUCCEEDED( source_->getQName( v_index, &qName, &len ) ) ) {
		const std::wstring tmp( qName, len );
		return tstringuty::getTString( tmp );
	}
	assert( false && "sAG[" );
	return _TEXT("");
}

void SAXAttributesAdaptor::getName(int v_index, tstring* v_pNS, tstring* v_pLocalName, tstring* v_pQName ) const
{
	const wchar_t* ns;
	const wchar_t* localName;
	const wchar_t* qName;
	int nsLen = 0;
	int localNameLen = 0;
	int qNameLen = 0;

	HRESULT hr = source_->getName( v_index, &ns, &nsLen, &localName, &localNameLen, &qName, &qNameLen );
	assert( SUCCEEDED( hr ) && "sG[" );

	if( v_pNS != NULL ) {
		const std::wstring tmp( ns, nsLen );
		*v_pNS = tstringuty::getTString( tmp );
	}
	if( v_pLocalName != NULL ) {
		const std::wstring tmp( localName, localNameLen );
		*v_pLocalName = tstringuty::getTString( tmp );
	}
	if( v_pQName != NULL ) {
		const std::wstring tmp( qName, qNameLen );
		*v_pQName = tstringuty::getTString( tmp );
	}
}

int SAXAttributesAdaptor::getIndexFromName( const tstring& v_ns, const tstring& v_localName ) const
{
	const std::wstring ns( tstringuty::getWStdString( v_ns ) );
	const std::wstring localName( tstringuty::getWStdString( v_localName ) );

	int idx;
	if( SUCCEEDED( source_->getIndexFromName(
		ns.c_str(),
		(int) ns.length(),
		localName.c_str(),
		(int) localName.length(),
		&idx
		) ) )
	{
		return idx;
	}
	return -1;
}

int SAXAttributesAdaptor::getIndexFromQName( const tstring& v_qName ) const
{
	const std::wstring qName( tstringuty::getWStdString( v_qName ) );
	int idx;
	if( SUCCEEDED( source_->getIndexFromQName(
		qName.c_str(),
		(int) qName.length(),
		&idx
		) ) )
	{
		return idx;
	}
	return -1;
}

tstring SAXAttributesAdaptor::getType(int v_index ) const
{
	const wchar_t* typeName;
	int len;

	if( SUCCEEDED( source_->getType( v_index, &typeName, &len ) ) ) {
		const std::wstring tmp( typeName, len );
		return tstringuty::getTString( tmp );
	}

	assert( false && "sG[łB" );
	return _TEXT("");
}

tstring SAXAttributesAdaptor::getTypeFromName( const tstring& v_ns, const tstring& v_localName ) const
{
	const std::wstring ns( tstringuty::getWStdString( v_ns ) );
	const std::wstring localName( tstringuty::getWStdString( v_localName ) );

	const wchar_t* typeName;
	int len;

	if( SUCCEEDED( source_->getTypeFromName(
		ns.c_str(),
		(int) ns.length(),
		localName.c_str(),
		(int) localName.length(),
		&typeName,
		&len
		) ) )
	{
		const std::wstring tmp( typeName, len );
		return tstringuty::getTString( tmp );
	}
	return _TEXT("");
}

tstring SAXAttributesAdaptor::getTypeFromQName( const tstring& v_qName ) const
{
	const std::wstring qName( tstringuty::getWStdString( v_qName ) );

	const wchar_t* typeName;
	int len;

	if( SUCCEEDED( source_->getTypeFromQName(
		qName.c_str(),
		(int) qName.length(),
		&typeName,
		&len
		) ) )
	{
		const std::wstring tmp( typeName, len );
		return tstringuty::getTString( tmp );
	}
	return _TEXT("");
}

tstring SAXAttributesAdaptor::getValue( int v_index ) const
{
	const wchar_t* value;
	int len;

	if( SUCCEEDED( source_->getValue( v_index, &value, &len ) ) ) {
		const std::wstring tmp( value, len );
		return tstringuty::getTString( tmp );
	}

	assert( false && "sG[łB" );
	return _TEXT("");
}

tstring SAXAttributesAdaptor::getValueFromName( const tstring& v_ns, const tstring& v_localName ) const
{
	const std::wstring ns( tstringuty::getWStdString( v_ns ) );
	const std::wstring localName( tstringuty::getWStdString( v_localName ) );

	const wchar_t* value;
	int len;

	if( SUCCEEDED( source_->getValueFromName(
		ns.c_str(),
		(int) ns.length(),
		localName.c_str(),
		(int) localName.length(),
		&value,
		&len
		) ) )
	{
		const std::wstring tmp( value, len );
		return tstringuty::getTString( tmp );
	}

	return _TEXT("");
}

tstring SAXAttributesAdaptor::getValueFromQName( const tstring& v_qName ) const
{
	const std::wstring qName( tstringuty::getWStdString( v_qName ) );

	const wchar_t* value;
	int len;

	if( SUCCEEDED( source_->getValueFromQName(
		qName.c_str(),
		(int) qName.length(),
		&value,
		&len
		) ) )
	{
		const std::wstring tmp( value, len );
		return tstringuty::getTString( tmp );
	}

	return _TEXT("");
}


//////////

SAXContentHandlerAdaptor::SAXContentHandlerAdaptor( SAXContentHandler& v_handler )
	: ref_( 1 )
	, pLocator_( NULL )
	, handler_( v_handler )
{
}

SAXContentHandlerAdaptor::~SAXContentHandlerAdaptor()
{
}

HRESULT __stdcall SAXContentHandlerAdaptor::QueryInterface(const IID& iid, void** ppvObj )
{
	if( iid == IID_IUnknown || iid == __uuidof( ISAXContentHandler ) ) {
		*ppvObj = this;
		AddRef();
		return NOERROR;
	}
	return E_NOINTERFACE;
}

ULONG __stdcall SAXContentHandlerAdaptor::AddRef(void)
{
	return ++ref_;
}

ULONG __stdcall SAXContentHandlerAdaptor::Release(void)
{
	if( --ref_ == 0 ) {
		delete this;
		return 0;
	}
	return ref_;
}

HRESULT __stdcall SAXContentHandlerAdaptor::putDocumentLocator(ISAXLocator* v_pLocator )
{
	pLocator_ = v_pLocator;
	pLocator_->AddRef();

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::startDocument(void)
{
	handler_.startDocument();

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::endDocument(void)
{
	if( pLocator_ != NULL ) {
		pLocator_->Release();
		pLocator_ = NULL;
	}

	handler_.endDocument();

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::startPrefixMapping(
	const wchar_t* pArg0,
	int arg0len,
	const wchar_t* pArg1,
	int arg1len )
{
	const std::wstring arg0( pArg0, arg0len );
	const std::wstring arg1( pArg1, arg1len );

	handler_.startPrefixMapping(
		tstringuty::getTString( arg0 ),
		tstringuty::getTString( arg1 )
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::endPrefixMapping(const wchar_t* pArg0, int arg0len )
{
	const std::wstring arg0( pArg0, arg0len );

	handler_.endPrefixMapping( tstringuty::getTString( arg0 ) );

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::startElement(
	const wchar_t* pNs,
	int nsLen,
	const wchar_t* pwchLocalName,
	int cchLocalName,
	const wchar_t* pQName,
	int QNameLen,
	ISAXAttributes* pAttr
	)
{
	std::wstring ns( pNs, nsLen );
	std::wstring localName( pwchLocalName, cchLocalName );
	std::wstring QName( pQName, QNameLen );

	const SAXAttributesAdaptor attr( pAttr );
	handler_.startElement(
		tstringuty::getTString( ns ),
		tstringuty::getTString( localName ),
		tstringuty::getTString( QName ),
		attr
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::endElement(
	const wchar_t *pNs,
	int nsLen,
	const wchar_t* pwchLocalName,
	int cchLocalName,
	const wchar_t *pQName,
	int QNameLen
	)
{
	std::wstring ns( pNs, nsLen );
	std::wstring localName( pwchLocalName, cchLocalName );
	std::wstring QName( pQName, QNameLen );

	handler_.endElement(
		tstringuty::getTString( ns ),
		tstringuty::getTString( localName ),
		tstringuty::getTString( QName )
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::characters(const wchar_t* p, int len )
{
	std::wstring chars( p, len );

	handler_.characters( tstringuty::getTString( chars ) );

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::ignorableWhitespace(const wchar_t* p, int len )
{
	std::wstring chars( p, len );

	handler_.ignorableWhitespace( tstringuty::getTString( chars ) );

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::processingInstruction(
	const wchar_t* pTarget,
	int targetLen,
	const wchar_t* pData,
	int dataLen
	)
{
	std::wstring target( pTarget, targetLen );
	std::wstring data( pData, dataLen );

	handler_.processingInstruction(
		tstringuty::getTString( target ),
		tstringuty::getTString( data )
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::skippedEntity(const wchar_t *pName, int nameLen )
{
	std::wstring name( pName, nameLen );

	handler_.skippedEntity( tstringuty::getTString( name ) );

	return S_OK;
}
