#include "stdafx.hpp"

#include "SAXParser.hpp"
#include "tstring.hpp"
#include "tstringUty.hpp"

#include <memory>

#include <msxml2.h>

namespace
{
	template<class T> class auto_release
	{
	private:
		auto_release( const auto_release& ); //<! Ȃ
		operator=( const auto_release& ); //<! Ȃ

	public:
		auto_release( T* v_ptr )
			: ptr_ ( v_ptr )
		{
		}

		~auto_release()
		{
			Release();
		}

		T* get() const
		{
			return ptr_;
		}

		void Release()
		{
			if( ptr_ != NULL ) {
				ptr_->Release();
				ptr_ = NULL;
			}
		}

	private:
		T* ptr_;
	};

	class DefaultSAXParser : public SAXParser
	{
	private:
		DefaultSAXParser( const DefaultSAXParser& ); //<! Ȃ
		operator=( const DefaultSAXParser& ); //<! Ȃ
	
	public:
		DefaultSAXParser()
		{
		}
		
		virtual ~DefaultSAXParser()
		{
		}
		
		virtual void parse( const tstring& v_url, SAXContentHandler& v_handler )
		{
			const std::wstring url( tstringuty::getWStdString( v_url ) );

			auto_release<SAXContentHandlerAdaptor> contentHandlerHolder(
				new SAXContentHandlerAdaptor( v_handler ) );

			ISAXXMLReader* pRdr = NULL;
			if( FAILED( ::CoCreateInstance(
				__uuidof(SAXXMLReader),
				NULL,
				CLSCTX_ALL,
				__uuidof(ISAXXMLReader),
				(void **) &pRdr
				) ) )
			{
				throw std::runtime_error( "MSXML Creation Failure!!!" ); //TODO: 悢Ol邱
			}
			auto_release<ISAXXMLReader> reader( pRdr );

			pRdr->putContentHandler( contentHandlerHolder.get() );
			if( FAILED( pRdr->parseURL( url.c_str() ) ) ) {
				throw std::runtime_error( "MSXML Parsing Failure!!!" ); //TODO: 悢Ol邱
			}
		}
	};
}


SAXParserFactory::SAXParserFactory()
{
}

SAXParserFactory::~SAXParserFactory()
{
}

SAXParserPtr SAXParserFactory::create()
{
	return SAXParserPtr( new DefaultSAXParser() );
}

