#include "stdafx.hpp"

#include "DialogLayoutExpander.hpp"

#include <assert.h>

DialogLayoutExpander::DialogLayoutExpander()
{
	parent_.hWnd = NULL;
}

DialogLayoutExpander::~DialogLayoutExpander()
{
}

void DialogLayoutExpander::setParent( HWND v_hWnd )
{
	//required:
	assert( v_hWnd != NULL && "v_hWndNULL͎wł܂B" );

	//do:
	WindowInfo info = { v_hWnd, { 0, 0, 0, 0 }, 0 };
	::GetWindowRect( v_hWnd, &info.rect );
	parent_ = info;
}

void DialogLayoutExpander::addChild( HWND v_hWnd, DWORD v_flag )
{
	//required:
	assert( v_hWnd != NULL && "v_hWndNULL͎wł܂B" );
	assert( parent_.hWnd != NULL && "Ă܂B" );

	//do:
	WindowInfo info = { v_hWnd, { 0, 0, 0, 0 }, v_flag };
	::GetWindowRect( v_hWnd, &info.rect );

	const int clientOffset_left = ::GetSystemMetrics( SM_CXFRAME );
	const int clientOffset_top = ::GetSystemMetrics( SM_CYFRAME ) + ::GetSystemMetrics( SM_CYCAPTION ) + ::GetSystemMetrics( SM_CYMENU );

	info.rect.top -= parent_.rect.top + clientOffset_top;
	info.rect.bottom -= parent_.rect.top + clientOffset_top;
	info.rect.left -= parent_.rect.left + clientOffset_left;
	info.rect.right -= parent_.rect.left + clientOffset_left;

	children_.push_back( info );
}

void DialogLayoutExpander::layout( LPRECT v_pRect )
{
	assert( v_pRect != NULL && "v_pRectNULL͎wł܂B" );
	assert( parent_.hWnd != NULL && "Ă܂B" );

	int width = v_pRect->right - v_pRect->left;
	int height = v_pRect->bottom - v_pRect->top;

	const int originWidth = parent_.rect.right - parent_.rect.left;
	const int originHeight = parent_.rect.bottom - parent_.rect.top;

	if( width < originWidth ) {
		width = originWidth;
		v_pRect->right = v_pRect->left + width;
	}
	if( height < originHeight ) {
		height = originHeight;
		v_pRect->bottom = v_pRect->top + height;
	}

	const int width_diff = width - originWidth;
	const int height_diff = height - originHeight;

	const int size = (int) children_.size();
	if( size > 0 ) {
		HDWP hdwp = ::BeginDeferWindowPos( size );
		if( hdwp != NULL ) {
			for( ChildList::const_iterator ite_children = children_.begin();
				ite_children != children_.end();
				++ite_children )
			{
				const WindowInfo& info = *ite_children;

				RECT rct = info.rect;
				if( info.flag & MOVE_LEFT ) {
					rct.left += width_diff;
				}
				if( info.flag & MOVE_TOP ) {
					rct.top += height_diff;
				}
				if( info.flag & MOVE_RIGHT ) {
					rct.right += width_diff;
				}
				if( info.flag & MOVE_BOTTOM ) {
					rct.bottom += height_diff;
				}

				::DeferWindowPos(
					hdwp,
					info.hWnd,
					NULL,
					rct.left,
					rct.top,
					(rct.right - rct.left),
					(rct.bottom - rct.top ),
					SWP_NOZORDER
					);

			}
			::EndDeferWindowPos( hdwp );
		}
	}
}
