#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "FWatchSettingDlg.hpp"
#include "TaskSettingDialog.hpp"
#include "tstringUty.hpp"

#include <assert.h>
#include <commctrl.h>

#include "WaitCursor.hpp"

FWatchSettingDlg::FWatchSettingDlg( WatchTaskGroup& v_watchTaskGroup )
	: hDlg_( NULL )
	, watchTaskGroup_( v_watchTaskGroup )
{
}

FWatchSettingDlg::~FWatchSettingDlg()
{
}

void FWatchSettingDlg::show( HWND hWnd )
{
	if( ::DialogBoxParam(
		pApp->getInstanceHandle(),
		MAKEINTRESOURCE( IDD_TASKLISTDIALOG ),
		hWnd,
		DlgProc,
		(LPARAM) this
		) == IDOK )
	{
		watchTaskGroup_.SaveInfData( pApp->getInfPath() );
	}
}

void FWatchSettingDlg::onInitDialog()
{
	hList_ = ::GetDlgItem( hDlg_, IDC_LIST );
	assert( hList_ != NULL );

	hStatus_ = ::GetDlgItem( hDlg_, IDC_THREADGROUP_STATUS );
	assert( hStatus_ != NULL );

	// X^C̕ύX
	ListView_SetExtendedListViewStyle( hList_, LVS_EX_FULLROWSELECT );

	// Jwb_̓o^
	LVCOLUMN data;
	data.mask = LVCF_TEXT | LVCF_WIDTH;
	data.cx = 100;
	const int colmx = GetColumnCount();
	for( int col=0; col<colmx; col++ ) {
		const tstring columnTitle = GetColTitle( col );
		data.pszText = (LPTSTR) columnTitle.c_str();
		ListView_InsertColumn( hList_, col, &data );
	}

	// Xgڂ̒ǉ
	const int mx = watchTaskGroup_.size();
	for( int idx=0; idx<mx; idx++ ) {
		LVITEM item;
		item.mask = LVIF_TEXT|LVIF_PARAM;
		item.iItem = idx;
		item.iSubItem = 0;
		item.pszText = _TEXT("");

		const int itemIndex = ListView_InsertItem( hList_, &item );
		for( int col = 0; col<colmx; col++ ) {
			const tstring& disp = GetColText( idx, col );
			ListView_SetItemText( hList_, itemIndex, col, (LPTSTR) disp.c_str() );
		}
	}

	displayStatus();

	layout_.setParent( hDlg_ );
	layout_.addChild( hList_, DialogLayoutExpander::MOVE_RIGHT | DialogLayoutExpander::MOVE_BOTTOM );
	layout_.addChild( hStatus_, DialogLayoutExpander::MOVE_TOP | DialogLayoutExpander::MOVE_BOTTOM | DialogLayoutExpander::MOVE_RIGHT | DialogLayoutExpander::MOVE_BOTTOM );

	layout_.addChild( ::GetDlgItem( hDlg_, IDOK ), DialogLayoutExpander::MOVE_TOP | DialogLayoutExpander::MOVE_BOTTOM | DialogLayoutExpander::MOVE_LEFT | DialogLayoutExpander::MOVE_RIGHT );
	layout_.addChild( ::GetDlgItem( hDlg_, IDCANCEL ), DialogLayoutExpander::MOVE_TOP | DialogLayoutExpander::MOVE_BOTTOM | DialogLayoutExpander::MOVE_LEFT | DialogLayoutExpander::MOVE_RIGHT );
}

void FWatchSettingDlg::onSize( WPARAM wParam, LPARAM lParam )
{
	RECT rct;
	::GetWindowRect( hDlg_, &rct );
	layout_.layout( &rct );
}

void FWatchSettingDlg::onSizing( WPARAM wParam, LPARAM lParam )
{
	RECT* pRect = (RECT*) lParam;
	layout_.layout( pRect );
}

void FWatchSettingDlg::displayStatus() const
{
	tstring status = pApp->LoadString( watchTaskGroup_.isDryRun() ? IDS_TASKMES_MODEDRYRUN : IDS_TASKMES_MODESTANDALONE );
	if( watchTaskGroup_.isModified() ) {
		status += pApp->LoadString( IDS_TASKMES_SETTINGDIRTY );
	}
	::SetWindowText( hStatus_, status.c_str() );
}

void FWatchSettingDlg::onEdit( bool bEditMode )
{
	HWND hList = GetDlgItem(hDlg_,IDC_LIST);
	int sel = -1; // XgRg[̑Is
	if( bEditMode ) {
		// CłΌ݂̑I擾
		int i = 0;
		while(i < ListView_GetItemCount(hList)){
			if(ListView_GetItemState(hList,i,LVIS_SELECTED)){
				LVITEM item;
				item.mask = LVIF_PARAM;
				item.iItem = i;
				if(ListView_GetItem(hList,&item)){
					sel = i;
					break;
				}
			}
			i++;
		}
		if(sel < 0){
			// IĂȂΌx𔭂ďIB
			MessageBeep(MB_ICONERROR);
			return;
		}
	}

	TaskSettingDialog sdlg( bEditMode ? watchTaskGroup_.getInfo( sel ) : CSettingInfo() );
	if( sdlg.show( hDlg_ ) ) {
		const CSettingInfo info = sdlg.createSettingInfo();
		
		LVITEM item;
		item.mask = LVIF_TEXT|LVIF_PARAM;
		item.iSubItem = 0;
		item.pszText = _TEXT("");

		if( bEditMode ){
			watchTaskGroup_.replace( sel, info );
			item.iItem = sel;
		}
		else {
			watchTaskGroup_.append( info );
			sel = watchTaskGroup_.size() - 1;
			item.iItem = sel;
			item.lParam = sel;
			ListView_InsertItem(hList,&item);
		}

		const int colmx = GetColumnCount();
		for( int col = 0; col<colmx; col++ ) {
			const tstring& disp = GetColText( sel, col );
			ListView_SetItemText( hList, sel, col, (LPTSTR)disp.c_str() );
		}
	}
}

void FWatchSettingDlg::onDelete()
{
	WaitCursor waitCursor;

	HWND hList = GetDlgItem(hDlg_,IDC_LIST);
	int idx = 0;
	while(idx < ListView_GetItemCount(hList)){
		if(ListView_GetItemState(hList,idx,LVIS_SELECTED)){
			watchTaskGroup_.erase( idx );
			ListView_DeleteItem( hList, idx );
			idx = 0;
			continue;
		}
		idx++;
	}
}

void FWatchSettingDlg::onSaveAsConfig()
{
	tstring filter = pApp->LoadString( IDS_SETTINGMES_FWATCHCONFFILE );
	tstring::size_type pos;
	while( ( pos = filter.find( '|' ) ) != tstring::npos ) {
		filter.replace( pos, 1, 1, '\0' );
	}
	filter.push_back( '\0' );

	TCHAR savename[MAX_PATH] = { 0 };
	OPENFILENAME ofn = {0};
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg_;
	ofn.hInstance = pApp->getInstanceHandle();
	ofn.lpstrFilter = filter.data();
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = savename;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST;
	ofn.lpstrDefExt = _TEXT("log");
	if( ::GetSaveFileName( &ofn ) ){
		watchTaskGroup_.SaveInfData( savename, true );
	}
}

BOOL FWatchSettingDlg::onCommand( UINT btn )
{
	BOOL result = TRUE;
	switch(btn)
	{
	case IDOK:
		::EndDialog(hDlg_, IDOK);
		break;

	case IDCANCEL:
		::EndDialog(hDlg_, IDCANCEL);
		break;

	case IDC_ADD:
	case IDC_EDIT:
		onEdit( btn == IDC_EDIT );
		displayStatus();
		break;

	case IDC_DEL:
		onDelete();
		displayStatus();
		break;

	case ID_SAVE_AS_CONFIG:
		onSaveAsConfig();
		break;

	default:
		result = FALSE;
		break;
	}
	return result;
}

BOOL FWatchSettingDlg::onNotify( WPARAM wParam, LPARAM lParam )
{
	const UINT uID = (UINT) wParam;
	const NMHDR* pNMHeader = (NMHDR*) lParam;
	
	if( uID == IDC_LIST ) {
		if( pNMHeader->code == NM_DBLCLK ) {
			const NMITEMACTIVATE* pNMItemActivate = (NMITEMACTIVATE*) pNMHeader;
			onEdit( true );
			displayStatus();
		}
		else if( pNMHeader->code == NM_RCLICK ) {
			HMENU hMenu = ::GetMenu( hDlg_ );
			assert( hMenu != NULL );
			HMENU hSubMenu = ::GetSubMenu( hMenu, 1 );
			assert( hSubMenu != NULL );
			const DWORD pos = ::GetMessagePos();
			::TrackPopupMenu(
				hSubMenu,
				TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RIGHTBUTTON,
				LOWORD( pos ),
				HIWORD( pos ),
				0,
				hDlg_,
				NULL
				); 
		}
		return TRUE;
	}

	return FALSE;
}

tstring FWatchSettingDlg::GetColTitle(int col) const
{
	//required:
	assert(col >= 0 && col < GetColumnCount() && "J͈̔͊OłB" );
	
	//do:
	return pApp->LoadString( IDS_SETTINGIDX0 + col );
}

int FWatchSettingDlg::GetColumnCount() const
{
	return 11;
}

tstring FWatchSettingDlg::GetColText( unsigned int idx, unsigned int col) const
{
	//required:
	assert( idx >= 0 && idx < watchTaskGroup_.size() && "ACe͈̔͊OłB" );

	//do:
	const CSettingInfo& settingInfo = watchTaskGroup_.getInfo( idx );
	switch(col)
	{
	case 0:
		return settingInfo.getWatchFile();
	case 1:
		return settingInfo.getWatchDir();
	case 2:
		return settingInfo.getAction();
	case 3:
		return settingInfo.getAppName();
	case 4:
		return settingInfo.getParam();
	case 5:
		return tstringuty::IntToString( settingInfo.getMaxProcess() );
	case 6:
		return settingInfo.getShowWindow().getDescription();
	case 7:
		return tstringuty::Int64ToString( settingInfo.getWaitWrite().GetTimeSpan() / ( 100 * 10000 ) );
	case 8:
		return tstringuty::Int64ToString( settingInfo.getTolerance().GetTimeSpan() / 10000 );
	case 9:
		return tstringuty::Int64ToString( settingInfo.getDeletePending().GetTimeSpan() / ( 100 * 10000 ) );
	case 10:
		return settingInfo.getLog();
	default:
		assert( false && "͈͊ÕJwłB" );
		return _TEXT("*ERR*");
	}
}

INT_PTR CALLBACK FWatchSettingDlg::DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	FWatchSettingDlg* me = (FWatchSettingDlg*) ::GetWindowLongPtr( hDlg, DWLP_USER );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( message == WM_INITDIALOG ) {
		me = (FWatchSettingDlg*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, (LONG) me );
		me->hDlg_ = hDlg;
		me->onInitDialog();
	}
	else {
		if( message == WM_COMMAND ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			return me->onCommand( LOWORD(wParam) );
		}
		else if( message == WM_NOTIFY ) {
			return me->onNotify( wParam, lParam );
		}
		else if( message == WM_SIZING ) {
			me->onSizing( wParam, lParam );
			return TRUE;
		}
		else if( message == WM_SIZE ) {
			me->onSize( wParam, lParam );
			return TRUE;
		}
	}
    return FALSE;
}

