#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "ServiceEntry.hpp"
#include "FWatchUI.hpp"
#include "FWatchVersionDlg.hpp"
#include "FWatchSettingDlg.hpp"
#include "tstring.hpp"

#include <assert.h>

#define MAX_LOADSTRING 100

const UINT FWatchUI::WM_TASKBARCREATED = ::RegisterWindowMessage( _TEXT("TaskbarCreated") );

FWatchUI::FWatchUI()
	: pTskIcon_( NULL )
	, hWnd_( NULL )
	, lockmenu_( false )
{
}

FWatchUI::~FWatchUI()
{
	delete pTskIcon_;
}

bool FWatchUI::create()
{
	//required:
	assert( hWnd_ == NULL && "CEBhE͍쐬ς݂łB" );

	//do:
	const tstring title = pApp->LoadString( IDS_APP_TITLE );
	const tstring windowClass = pApp->LoadString( IDC_FWATCH );

	RegisterClass( windowClass.c_str() );
	return ::CreateWindow(
		windowClass.c_str(),
		title.c_str(),
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		0,
		CW_USEDEFAULT,
		0,
		NULL,
		NULL,
		pApp->getInstanceHandle(),
		this
		) != NULL;
}

ATOM FWatchUI::RegisterClass( LPCTSTR szWindowClass )
{
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= pApp->getInstanceHandle();
	wcex.hIcon			= LoadIcon( pApp->getInstanceHandle(), (LPCTSTR) IDI_FWATCH );
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL; // (LPCSTR)IDC_FWATCH;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon( pApp->getInstanceHandle(), (LPCTSTR) IDI_SMALL );

	return RegisterClassEx( &wcex );
}

void FWatchUI::onClose()
{
	if( pApp->getWatchTaskGroup().isModified() ) {
		if( pApp->showMessageBox( MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON2, NULL, IDS_CLOSECONFIRM_NOSAVE ) != IDYES ) {
			return;
		}
	}
	::DestroyWindow( hWnd_ );
}

void FWatchUI::onDestroy()
{
	delete pTskIcon_;
	pTskIcon_ = NULL;
}

void FWatchUI::onTaskbarCreate()
{
	pTskIcon_->ReCreate();
}

void FWatchUI::onCreate( LPCREATESTRUCT pCreateStruct )
{
	pTskIcon_ = new TaskbarNotificationIcon(
		hWnd_,
		1,
		WM_USER_NOTIFYTASKICON,
		IDI_FWATCH,
		IDS_TASKMES_WATCH
		);
	pTskIcon_->Create();
}

void FWatchUI::onCommand( UINT wmId )
{
	if(wmId == IDM_HELP){
		pApp->showHelp( hWnd_ );
	}
	else if( ! lockmenu_ ) {
		lockmenu_ = true;
		switch( wmId ) 
		{
		case IDM_SETTING:
			{
				FWatchSettingDlg dlg( pApp->getWatchTaskGroup() );
				dlg.show( hWnd_ );
			}
			break;

		case IDM_ABOUT:
			{
				FWatchVersionDlg dlg;
				dlg.show( hWnd_ );
			}
			break;

		case IDM_EXIT:
			::SendMessage( hWnd_, WM_CLOSE, 0, 0 );
			break;

		case IDM_SERVICE_START:
			ServiceRetart();
			break;

		case IDM_SERVICE_STOP:
			ServiceStop();
			break;
		}
		lockmenu_ = false;
	}
}

void FWatchUI::onTaskIconNotify( WPARAM wParam, LPARAM lParam )
{
	UINT uID = (UINT) wParam; 
	UINT uMouseMsg = (UINT) lParam; 
	if (uMouseMsg == WM_LBUTTONDOWN) {
		::SetForegroundWindow( hWnd_ );
	}
	else if (uMouseMsg == WM_LBUTTONDBLCLK) {
		::SendMessage(hWnd_, WM_COMMAND, IDM_SETTING, 0);
	}
	else if (uMouseMsg == WM_RBUTTONDOWN) {
		::SetForegroundWindow( hWnd_ );
		HMENU hMenu = ::LoadMenu( pApp->getInstanceHandle(), MAKEINTRESOURCE(IDC_FWATCH) );
		assert( hMenu != NULL );

		POINT pt;
		GetCursorPos(&pt);
		DWORD pos = GetMessagePos();
		if( ! lockmenu_ ){
			lockmenu_ = true;
			BOOL bRunning = FALSE;
			if( IsRegistService( bRunning ) ){
				// T[rXCXg[Ă΃T[rX̏Ԃ̕\ƃRg[\ɂ
				HMENU hSubMenu = GetSubMenu(hMenu,1);
				MENUITEMINFO minfo = {0};
				minfo.cbSize = sizeof(MENUITEMINFO);
				minfo.fMask  = MIIM_STATE;
				minfo.fState =  bRunning?MFS_GRAYED:MFS_ENABLED;
				SetMenuItemInfo(hMenu,IDM_SERVICE_START,false,&minfo);
				minfo.fState = !bRunning?MFS_GRAYED:MFS_ENABLED;
				SetMenuItemInfo(hMenu,IDM_SERVICE_STOP,false,&minfo);
				TrackPopupMenu(hSubMenu,TPM_LEFTALIGN|TPM_BOTTOMALIGN|TPM_RIGHTBUTTON,
				pt.x,pt.y,0, hWnd_ ,NULL);
			}
			else{
				// T[rXCXg[ĂȂꍇ
				HMENU hSubMenu = GetSubMenu(hMenu,0);
				TrackPopupMenu(hSubMenu,TPM_LEFTALIGN|TPM_BOTTOMALIGN|TPM_RIGHTBUTTON,
				pt.x,pt.y,0, hWnd_ ,NULL);
			}
			lockmenu_ = false;
		}
		else{
			HMENU hSubMenu = GetSubMenu(hMenu,2);
			TrackPopupMenu(hSubMenu,TPM_LEFTALIGN|TPM_BOTTOMALIGN|TPM_RIGHTBUTTON,
			pt.x,pt.y,0, hWnd_ ,NULL);
		}
	}
}

LRESULT CALLBACK FWatchUI::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	FWatchUI* me = (FWatchUI*) ::GetWindowLongPtr( hWnd, GWLP_USERDATA );
	assert( ( me == NULL || me->hWnd_ == hWnd ) && "QƂsłB" );

	if( message == WM_CREATE ) {
		me = (FWatchUI*)((LPCREATESTRUCT) lParam)->lpCreateParams;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hWnd, GWLP_USERDATA, (LONG) me );
		me->hWnd_ = hWnd;
		me->onCreate( (LPCREATESTRUCT) lParam );
	}
	else if(message == WM_TASKBARCREATED){
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		me->onTaskbarCreate();
	}
	else {
		switch( message ) 
		{
		case WM_COMMAND:
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			me->onCommand( LOWORD(wParam) );
			break;

		case WM_CLOSE:
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			me->onClose();
			return 0;

		case WM_DESTROY:
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			me->onDestroy();
			PostQuitMessage( 0 );
			break;

		case WM_ENDSESSION:
			if(wParam){
				::DestroyWindow( hWnd );
			}
			break;

		case WM_USER_NOTIFYTASKICON:
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			me->onTaskIconNotify( wParam, lParam );
			break;

		default:
			break;
		}
	}
	return DefWindowProc( hWnd, message, wParam, lParam );
}

