#include "stdafx.hpp"

#include "PassiveTimer.hpp"

#include <assert.h>

PassiveTimer::PassiveTimer( const CFileTimeSpan& v_span, const CFileTime& v_intialStartTime, const bool v_enabled )
	: enabled_( v_enabled )
	, span_ ( v_span )
	, startTime_ ( v_intialStartTime )
{
	assert( v_span >= 0 && "v_spanɕ̒l͎wł܂B" );
}

PassiveTimer::~PassiveTimer()
{
}

bool PassiveTimer::isSignaled( const CFileTime& v_now ) const
{
	return enabled_ && ( ( span_ == 0 ) || ( ( v_now - startTime_ ) > span_ ) );
}

void PassiveTimer::reset( const CFileTime& v_startTime, const bool v_enabled )
{
	enabled_ = v_enabled;
	startTime_ = v_startTime;
}

const CFileTimeSpan& PassiveTimer::getSpan() const
{
	return span_;
}

bool PassiveTimer::isEnabled() const
{
	return enabled_;
}

