#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "SettingInfo.hpp"
#include "tstringUty.hpp"

#include <assert.h>

ShowWindowType::ShowWindowType()
	: showWindowType_( ShowWindowType::NORMAL )
{
}

ShowWindowType::ShowWindowType( const int v_showWindowType )
	: showWindowType_( v_showWindowType )
{
	assert( v_showWindowType >= 0 && v_showWindowType <= 4 && "͈͊OłB" );
}

ShowWindowType::ShowWindowType( const ShowWindowType& v_other )
	: showWindowType_( v_other.showWindowType_ )
{
}

ShowWindowType& ShowWindowType::operator=( const ShowWindowType& v_other )
{
	showWindowType_ = v_other.showWindowType_;
	return *this;
}

ShowWindowType::operator int() const
{
	return showWindowType_;
}

tstring ShowWindowType::getDescription() const
{
	return pApp->LoadString( IDS_SHOWINDOWTYPE_0 + showWindowType_ );
}

int ShowWindowType::getShowCommand() const
{
	int nShowCmd = SW_SHOWNORMAL;
	switch( showWindowType_ )
	{
	case 0:
		nShowCmd = SW_SHOWMINNOACTIVE;
		break;
	case 1:
		nShowCmd = SW_SHOWNORMAL;
		break;
	case 2:
		nShowCmd = SW_SHOWMAXIMIZED;
		break;
	case 3:
		nShowCmd = SW_HIDE;
		break;
	case 4:
		nShowCmd = SW_SHOWMINIMIZED;
		break;
	default:
		break;
	}
	return nShowCmd;
}

ShowWindowType ShowWindowType::valueOf( const int v_showWindowType )
{
	if( v_showWindowType >= 0 && v_showWindowType <= 4 ) {
		return ShowWindowType( v_showWindowType );
	}
	return ShowWindowType( 1 );
}

///////////////////////////////////////////////////////

CSettingInfo::CSettingInfo()
{
	watchFile_ = pApp->LoadString( IDS_DEFAULTPARAM_FINDNAME );
	persistenceDelaySpan_ = pApp->LoadInteger( IDS_PERSISTENCEDELAYSPAN ) * 1000 * 10000;
	action_ = pApp->LoadString( IDS_DEFAULTPARAM_ACTION );
	param_ = pApp->LoadString( IDS_DEFAULTPARAM_PARAM );

	showWindow_ = ShowWindowType::valueOf( pApp->LoadInteger( IDS_DEFAULTPARAM_SHOW ) );

	nWaitWrite_ = pApp->LoadInteger( IDS_DEFAULTPARAM_WAIT ) * 100 * 10000;
	nTolerance_ = pApp->LoadInteger( IDS_DEFAULTPARAM_TOLERANCE ) * 10000;
	nMaxProcess_ = pApp->LoadInteger( IDS_DEFAULTPARAM_MAXPROCESS );

	nMaxDepth_ = pApp->LoadInteger( IDS_DEFAULTPARAM_MAXDEPTH );
	nForceInterval_ = pApp->LoadInteger( IDS_DEFAULTPARAM_FORCEINTERVAL ) * 1000;
	nDirNotificationAPIRetryInterval_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DIRNOTIFICATIONRETRYSPAN ) * 1000 * 10000;
	nDirNotificationAPIExpirySpan_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DIRNOTIFICATIONEXPIRYSPAN ) * 1000 * 10000;
	bUsingNotificationAPI_ = pApp->LoadInteger( IDS_DEFAULTPARAM_USEDIRNOTIFICATION ) != 0 ? true : false;

	nDeletePending_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DELETEPENDING ) * 100 * 10000;

	watchDir_.clear();
	persistentFile_.clear();
	appName_.clear();
	log_.clear();

	appCurrentDir_ = pApp->LoadString( IDS_DEFAULTPARAM_APPCURRENTDIR );
	delaySignalSpan_ = pApp->LoadInteger( IDS_DEFAULTPARAM_DELAYSIGNALSPAN );
}

CSettingInfo::CSettingInfo( const CSettingInfo& v_other )
	: watchDir_( v_other.watchDir_ )
	, watchFile_( v_other.watchFile_ )
	, persistentFile_( v_other.persistentFile_ )
	, persistenceDelaySpan_( v_other.persistenceDelaySpan_ )
	, action_( v_other.action_ )
	, appName_( v_other.appName_ )
	, param_( v_other.param_ )
	, log_( v_other.log_ )
	, nWaitWrite_( v_other.nWaitWrite_ )
	, nMaxProcess_( v_other.nMaxProcess_ )
	, showWindow_( v_other.showWindow_ )
	, nTolerance_ ( v_other.nTolerance_ )
	, nDeletePending_ ( v_other.nDeletePending_ )
	, nMaxDepth_( v_other.nMaxDepth_ )
	, nForceInterval_( v_other.nForceInterval_ )
	, nDirNotificationAPIRetryInterval_( v_other.nDirNotificationAPIRetryInterval_ )
	, nDirNotificationAPIExpirySpan_( v_other.nDirNotificationAPIExpirySpan_ )
	, bUsingNotificationAPI_( v_other.bUsingNotificationAPI_ )
	, appCurrentDir_( v_other.appCurrentDir_ )
	, delaySignalSpan_( v_other.delaySignalSpan_ )
{
}

CSettingInfo& CSettingInfo::operator=( const CSettingInfo& v_other )
{
	if( &v_other  == this ) {
		return *this;
	}

	watchDir_ = v_other.watchDir_;
	watchFile_ = v_other.watchFile_;
	persistentFile_ = v_other.persistentFile_;
	persistenceDelaySpan_ = v_other.persistenceDelaySpan_;
	action_ = v_other.action_;
	appName_ = v_other.appName_;
	param_ = v_other.param_;
	log_ = v_other.log_;

	nWaitWrite_ = v_other.nWaitWrite_;
	nMaxProcess_ = v_other.nMaxProcess_;
	showWindow_ = v_other.showWindow_;
	nTolerance_ = v_other.nTolerance_;
	nDeletePending_ = v_other.nDeletePending_;

	nMaxDepth_ = v_other.nMaxDepth_;
	nForceInterval_ = v_other.nForceInterval_;
	nDirNotificationAPIRetryInterval_ = v_other.nDirNotificationAPIRetryInterval_;
	nDirNotificationAPIExpirySpan_ = v_other.nDirNotificationAPIExpirySpan_;
	bUsingNotificationAPI_ = v_other.bUsingNotificationAPI_;

	appCurrentDir_ = v_other.appCurrentDir_;
	delaySignalSpan_ = v_other.delaySignalSpan_;

	return *this;
}


CSettingInfo::~CSettingInfo()
{
}

