#include "stdafx.hpp"

#include "Task.hpp"

#include <assert.h>


BasicMultiTask::BasicMultiTask( const ThreadGroupProfile& v_profile )
	: profile_( v_profile )
{
	hInterrupted_ = ::CreateEvent( NULL, FALSE, FALSE, NULL );
	assert( hInterrupted_ != NULL && "Cxg쐬ł܂B" );
}

BasicMultiTask::~BasicMultiTask()
{
	resetSchedule();
	::CloseHandle( hInterrupted_ );
}

/*!
 * XPW[Jn܂B
 */
void BasicMultiTask::startSchedule()
{
	start();
}

/*!
 * XPW[Ă邩擾܂B
 * \return XPW[ĂtrueAłȂfalse
 */
bool BasicMultiTask::isScheduling() const
{
	return isRunning();
}

/*!
 * XPW[~܂B
 * XPW[͓o^ꂽ܂܂łĊJ\łB
 */
void BasicMultiTask::stopSchedule()
{
	stop();
}

/*!
 * XPW[Zbg܂B
 * ׂẴXPW[̓o^폜܂B
 */
void BasicMultiTask::resetSchedule()
{
	stopSchedule();

	// 폜Ώۂ̃^XN폜B
	for( TaskStateList::iterator ite_taskStateList = taskStateList_.begin();
		ite_taskStateList != taskStateList_.end();
		++ite_taskStateList )
	{
		TaskState& taskState = *ite_taskStateList;
		if( taskState.bAutoRelease_ ) {
			delete taskState.task_;
		}
	}
	taskStateList_.clear();
}


void BasicMultiTask::run()
{
	for(;;) {
		CriticalSectionLock lock( lock_ );

		const size_t cnt = 2 + taskStateList_.size();
		assert( cnt < 64 && "ҋ@nh̏𒴂Ă܂B" );

		std::vector<HANDLE> handles( cnt );
		handles[ 0 ] = hStopEvent_;
		handles[ 1 ] = hInterrupted_;
		int idx = 2;

		for( TaskStateList::iterator ite_taskStateList = taskStateList_.begin();
			ite_taskStateList != taskStateList_.end();
			++ite_taskStateList )
		{
			TaskState& taskState = *ite_taskStateList;

			if( ! taskState.bInit_ ) {
				// ܂JnCxgĂȂΊJnCxg𔭐B
				taskState.task_->onThreadBinded();
				taskState.bInit_ = true;
				taskState.bExit_ = false;
			}

			// ʒm
			taskState.task_->onThreadTick();

			// ҋ@nh̎擾
			HANDLE handle = taskState.task_->getWaitableHandle();
			if( handle == NULL ) {
				handle = hInterrupted_; // lߕƂĎgAӖȂnhłB
			}
			handles[ idx ] = handle;
			idx++;
		}

		// ҋ@
		const DWORD result = ::MsgWaitForMultipleObjects(
			(DWORD) cnt,
			&handles[0],
			FALSE,
			profile_.getBaseCycleSpan(),
			QS_ALLEVENTS
			);
		
		if( result == WAIT_TIMEOUT ) {
			// ܂B
		}
		else if( result == WAIT_FAILED || result == WAIT_OBJECT_0 || result == WAIT_ABANDONED_0 ) {
			// Xbh~Cxg
			break;
		}
		else if( result == ( WAIT_OBJECT_0 + cnt ) ) {
			// bZ[W̏
			bool quit = false;
			MSG msg;
			while( ::PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) ) {
				if( msg.message == WM_QUIT ) {
					quit = true;
					break;
				}
				::DispatchMessage( &msg );
			}
			if( quit ) {
				// IbZ[Wɂ郋[v̏I
				break;
			}
		}
		else {
			// ҋ@A܂̓^XNɑVOȉ
			size_t idx = 0;
			if( result >= WAIT_OBJECT_0 && result < ( WAIT_OBJECT_0 + cnt ) ) {
				idx = result - WAIT_OBJECT_0;
			}
			else if( result >= WAIT_ABANDONED_0 && result < ( WAIT_ABANDONED_0 + cnt ) ) {
				idx = result - WAIT_ABANDONED_0;
			}
			assert( idx >= 0 && idx < cnt && "Cxǧʂ͈͊OłB" );

			if( idx >= 2 && handles[ idx ] != hInterrupted_ ) {
				taskStateList_[ idx - 2 ].task_->onThreadSignal();
			}
		}
		lock.release();
		::Sleep( 0 ); // c̃XCXԂ𓯂Dx̑̃Xbhɓn܂B
	}

	// ICxg
	CriticalSectionLock lock( lock_ );
	for( TaskStateList::iterator ite_taskStateList = taskStateList_.begin();
		ite_taskStateList != taskStateList_.end();
		++ite_taskStateList )
	{
		TaskState& taskState = *ite_taskStateList;
		if( taskState.bInit_ && ! taskState.bExit_ ) {
			// CxgĂAICxgĂȂꍇ͔B
			taskState.task_->onThreadUnbinded();
			taskState.bExit_ = true;
			taskState.bInit_ = false;
		}
	}
}

bool BasicMultiTask::appendTask( Task* v_pTask, bool v_autoRelease )
{
	//required:
	assert( v_pTask != NULL && "v_pTaskNULL͎wł܂B" );

	//do:
	interrupt();
	CriticalSectionLock lock( lock_ );
	bool result = false;
	if( MAX_TASK - taskStateList_.size() > 0 ) {
		TaskState taskState = { v_pTask, false, false, v_autoRelease };
		taskStateList_.push_back( taskState );
		result = true;
	}
	return result;
}

bool BasicMultiTask::removeTask( Task* v_pTask )
{
	//required:
	assert( v_pTask != NULL && "v_pTaskNULL͎wł܂B" );

	//do:
	bool removed = false;
	interrupt();
	CriticalSectionLock lock( lock_ );
	for( TaskStateList::iterator ite_taskStateList = taskStateList_.begin();
		ite_taskStateList != taskStateList_.end();
		)
	{
		TaskState& taskState = *ite_taskStateList;
		if( taskState.task_ == v_pTask ) {
			if( taskState.bInit_ && ! taskState.bExit_ ) {
				// CxgĂAICxgĂȂꍇ͔B
				taskState.task_->onThreadUnbinded();
			}
			if( taskState.bAutoRelease_ ) {
				delete taskState.task_;
			}
			ite_taskStateList = taskStateList_.erase( ite_taskStateList );
			removed = true;
		}
		else {
			++ite_taskStateList;
		}
	}

	return removed;
}

void BasicMultiTask::interrupt() const
{
	::PulseEvent( hInterrupted_ );
}

size_t BasicMultiTask::size() const
{
	interrupt();
	CriticalSectionLock lock( lock_ );
	return taskStateList_.size();
}


///////////////////////


BasicMultiTaskEx::BasicMultiTaskEx( const ThreadGroupProfile& v_profile )
	: profile_( v_profile )
{
	multiTaskList_.push_back( new BasicMultiTask( profile_ ) );
}

BasicMultiTaskEx::~BasicMultiTaskEx()
{
	resetSchedule();
	for( BasicMultiTaskList::iterator ite_multiTaskList = multiTaskList_.begin();
		ite_multiTaskList != multiTaskList_.end();
		++ite_multiTaskList )
	{
		BasicMultiTask* pMultiTask = *ite_multiTaskList;
		delete pMultiTask;
	}
}

/*!
 * XPW[Jn܂B
 */
void BasicMultiTaskEx::startSchedule()
{
	for( BasicMultiTaskList::iterator ite_multiTaskList = multiTaskList_.begin();
		ite_multiTaskList != multiTaskList_.end();
		++ite_multiTaskList )
	{
		BasicMultiTask* pMultiTask = *ite_multiTaskList;
		pMultiTask->startSchedule();
		assert( pMultiTask->isScheduling() && "JnĂ܂B" );
	}
}

/*!
 * XPW[Ă邩擾܂B
 * \return XPW[ĂtrueAłȂfalse
 */
bool BasicMultiTaskEx::isScheduling() const
{
	for( BasicMultiTaskList::const_iterator ite_multiTaskList = multiTaskList_.begin();
		ite_multiTaskList != multiTaskList_.end();
		++ite_multiTaskList )
	{
		const BasicMultiTask* pMultiTask = *ite_multiTaskList;
		const bool running = pMultiTask->isScheduling();
		if( running ) {
			return true;
		}
	}
	return false;
}

/*!
 * XPW[~܂B
 * XPW[͓o^ꂽ܂܂łĊJ\łB
 */
void BasicMultiTaskEx::stopSchedule()
{
	for( BasicMultiTaskList::iterator ite_multiTaskList = multiTaskList_.begin();
		ite_multiTaskList != multiTaskList_.end();
		++ite_multiTaskList )
	{
		BasicMultiTask* pMultiTask = *ite_multiTaskList;
		pMultiTask->stopSchedule();
		assert( ! pMultiTask->isScheduling() && "~Ă܂B" );
	}
}

/*!
 * XPW[Zbg܂B
 * ׂẴXPW[̓o^폜܂B
 */
void BasicMultiTaskEx::resetSchedule()
{
	for( BasicMultiTaskList::iterator ite_multiTaskList = multiTaskList_.begin();
		ite_multiTaskList != multiTaskList_.end();
		++ite_multiTaskList )
	{
		BasicMultiTask* pMultiTask = *ite_multiTaskList;
		pMultiTask->resetSchedule();
		assert( ! pMultiTask->isScheduling() && "~Ă܂B" );
	}
	// Xbh1ɏkނB
	while( multiTaskList_.size() > 1 ) {
		BasicMultiTask* pMultiTask = multiTaskList_.back();
		delete pMultiTask;
		multiTaskList_.pop_back();
	}
	assert( multiTaskList_.size() == 1 && "Xbh1ł͂܂B" );
}

/*!
 * o^Ă^XNԂ܂B
 * \return o^Ă^XN
 */
size_t BasicMultiTaskEx::size() const
{
	size_t count = 0;
	for( BasicMultiTaskList::const_iterator ite_multiTaskList = multiTaskList_.begin();
		ite_multiTaskList != multiTaskList_.end();
		++ite_multiTaskList )
	{
		const BasicMultiTask* pMultiTask = *ite_multiTaskList;
		count += pMultiTask->size();
	}
	return count;
}

/*!
 * ^XNǉ܂B
 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
 * ^XN̏𒴂Ȃǂɂ^XNo^łȂꍇfalseԂ܂B
 * \param v_task ^XN
 * \param v_autoRelease 폜ꍇ
 * \return o^ꂽꍇAtrue
 */
bool BasicMultiTaskEx::appendTask( Task* v_pTask, bool v_autoRelease )
{
	//required:
	assert( v_pTask != NULL && "v_pTasknull͎wł܂B" );

	//do:
	for( BasicMultiTaskList::reverse_iterator ite_multiTaskList = multiTaskList_.rbegin();
		ite_multiTaskList != multiTaskList_.rend();
		++ite_multiTaskList )
	{
		BasicMultiTask* pMultiTask = *ite_multiTaskList;
		const size_t count = pMultiTask->size();
		if( count < pMultiTask->getMaxTask() ) {
			if( pMultiTask->appendTask( v_pTask, v_autoRelease ) ) {
				return true;
			}
		}
	}
	
	// 󂫂Ȃ̂Ŋg܂B
	BasicMultiTask* pNewMultiTask = new BasicMultiTask( profile_ );
	multiTaskList_.push_back( pNewMultiTask );
	::OutputDebugString( _TEXT("ǉ̃Xbh쐬܂B\n") );

	return pNewMultiTask->appendTask( v_pTask, v_autoRelease );
}

/*!
 * ^XN폜܂B
 * łɃ^XNJnĂꍇ́AICxg܂B
 * ݂Ȃ^XNw肵ꍇ͉܂B
 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
 * \param v_task ^XN
 * \return 폜ꂽꍇtrueAΏۂȂꍇfalse
 */
bool BasicMultiTaskEx::removeTask( Task* v_pTask )
{
	for( BasicMultiTaskList::reverse_iterator ite_multiTaskList = multiTaskList_.rbegin();
		ite_multiTaskList != multiTaskList_.rend();
		++ite_multiTaskList )
	{
		BasicMultiTask* pMultiTask = *ite_multiTaskList;
		if( pMultiTask->removeTask( v_pTask ) ) {
			return true;
		}
	}
	return false;
}
