#ifndef INCLUDE_H_THREAD
#define INCLUDE_H_THREAD

class CriticalSection
{
private:
	CriticalSection( const CriticalSection& ); //<! Ȃ
	operator=( const CriticalSection& ); //<! Ȃ

public:
	CriticalSection();
	~CriticalSection();

private:
	friend class CriticalSectionLock;
	CRITICAL_SECTION criticalSection_;
};

class CriticalSectionLock
{
private:
	CriticalSectionLock( const CriticalSectionLock& ); //<! Ȃ
	operator=( const CriticalSectionLock& ); //<! Ȃ

public:
	CriticalSectionLock( CriticalSection& v_criticalSection );
	void release();
	~CriticalSectionLock();

private:
	bool locked_;
	CriticalSection& criticalSection_;
};

class Thread
{
public:
	virtual ~Thread() {}

	virtual void start() = 0;
	virtual void stop() = 0;
	virtual void sendStopInterrupt() = 0;
	virtual bool isRunning() const = 0;
};

class BasicThread : public Thread
{
public:
	BasicThread() throw();
	virtual ~BasicThread() throw();

	virtual void start();

	virtual void stop();
	virtual void sendStopInterrupt();

	virtual bool isRunning() const;

protected:
	virtual void run() = 0;

private:
	static unsigned __stdcall threadProc( void* pParam );

protected:
	HANDLE hStopEvent_;

private:
	HANDLE hStartedEvent_;
	HANDLE hThread_;
	DWORD nThreadID_;
};

#endif
