#ifndef INCLUDE_H_WATCHTASKGROUP
#define INCLUDE_H_WATCHTASKGROUP

#include "WatchTask.hpp"
#include "SettingInfo.hpp"

#include "Thread.hpp"

#include "tstring.hpp"
#include <vector>

class WatchTaskGroup
{
private:
	WatchTaskGroup( const WatchTaskGroup& ); //<! Ȃ
	operator=( const WatchTaskGroup& ); //<! Ȃ

public:
	
	/*!
	 * ĎXbhO[v\z܂B
	 * hC[hLɂƃXbh͎ۂɂ͍쐬ꂸҏŴ݂ƂȂ܂B
	 * \param v_dryrun hC[h̏ꍇAtrue
	 */
	WatchTaskGroup( const bool v_dryrun );

	virtual ~WatchTaskGroup();
	
	/*!
	 * ĎXbhJn܂B
	 * hC̏ꍇ͉܂B
	 */
	void startWatch();

	/*!
	 * ĎXbh~܂B
	 * hC̏ꍇ͉܂B
	 */
	void stopWatch();

	/*!
	 * ĎXbh~AׂẴ^XNNA܂B
	 */
	void clear();

	/*!
	 * ĎXbhsłtrueԂ܂B
	 * \return ĎXbhsłtrue
	 */
	bool isRunning() const;

	/*!
	 * hC[hł邩擾܂B
	 * \return hC[hłtrue
	 */
	bool isDryRun() const;

	bool append( const CSettingInfo& v_settingInfo );
	bool replace( unsigned int idx, const CSettingInfo& v_settingInfo );
	bool erase( unsigned int idx );

	const CSettingInfo& getInfo( unsigned int idx ) const;
	unsigned int size() const;

	/*!
	 * Ď^XNt@Cǂݍݐݒ肵܂B
	 * Xbh͊JnĂĂ͂Ȃ܂B
	 * ĎJnɂstartWatch\bhĂяo܂B
	 * t@Cǂݍ܂ꂽꍇtrueԂ܂B
	 * t@Cw肳ĂȂA݂ȂꍇfalseԂ܂B
	 * \param InfPath t@CA܂͋󕶎
	 * \return t@Cǂݍ܂ꂽꍇAtrue
	 */
	bool LoadInfData( const tstring& InfPath );

	/*!
	 * ݂̊Ď^XNt@Cɏo܂B
	 * Xbh͒~ĂȂĂ܂܂B
	 * ύXĂ炸oKvȂA߂ꍇtrueԂ܂B
	 * \param InfPath t@CA܂͋󕶎
	 * \param XV̗Lɂ炸t@Cɏoꍇtruew肵܂B
	 * \return t@Cɏ܂ꂽꍇtrueAłȂfalse
	 */
	bool SaveInfData( const tstring& InfPath, bool bForce = false ) const;

	/*!
	 * ĎXbhŌɓǂݍ܂ĂύXĂ邩擾܂B
	 * \return ύXĂꍇtrueAłȂfalse
	 */
	bool isModified() const;

private:
	const bool dryrun_;
	mutable bool modified_;

	BasicMultiTaskEx multiTask_;

	typedef std::vector<WatchTask*> WatchTaskList;
	WatchTaskList taskList_;
};

#endif
