#include "stdafx.hpp"

#include "ActionInvoker.hpp"

#include <vector>

#include <assert.h>

#include "StringExpander.hpp"
#include "SplitPath.hpp"


AbstractActionInvoker::AbstractActionInvoker( const ActionSettingInfo& v_actionSettingInfo ) throw()
	: actionSettingInfo_( v_actionSettingInfo )
{
}

AbstractActionInvoker::~AbstractActionInvoker() throw()
{
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end();
		++ite )
	{
		HANDLE hProcess = *ite;
		::CloseHandle( hProcess );
	}
	processHandleList_.clear();
}

unsigned int AbstractActionInvoker::sweepTerminatedProcess() throw()
{
	unsigned int count = 0;
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end(); )
	{
		HANDLE hProcess = *ite;
		const DWORD ret = ::WaitForSingleObject( hProcess, 0 );
		if( ret != WAIT_TIMEOUT ) {
			// vZXIĂȂƂmłȂΏIĂƂ݂ȂB
			::CloseHandle( hProcess );
			ite = processHandleList_.erase( ite );
		}
		else {
			count++;
			++ite;
		}
	}
	return count;
}

void AbstractActionInvoker::addTraceProcessHandle( HANDLE v_hProcess ) throw()
{
	if( v_hProcess == NULL ) {
		return;
	}

	if( actionSettingInfo_.getMaxProcess() > 0 ) {
		processHandleList_.push_back( v_hProcess );
	}
	else {
		// Ȃ̂ŒǐՂ̕KvȂ
		::CloseHandle( v_hProcess );
	}
}

const ActionSettingInfo& AbstractActionInvoker::getSettingInfo() const throw()
{
	return actionSettingInfo_;
}


//////////

ActionInvokerFactory::ActionInvokerFactory()
{
}

ActionInvokerFactory::~ActionInvokerFactory()
{
}

ActionInvokerPtr ActionInvokerFactory::create( const ActionSettingInfo& v_actionSettingInfo ) const
{
	return ActionInvokerPtr( new ShellExecActionInvoker( v_actionSettingInfo ) );
}

//////////


ShellExecActionInvoker::ShellExecActionInvoker( const ActionSettingInfo& v_actionSettingInfo ) throw()
	: AbstractActionInvoker( v_actionSettingInfo )
{
}

ShellExecActionInvoker::~ShellExecActionInvoker() throw()
{
}

bool ShellExecActionInvoker::createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw()
{
	//required:
	assert( ! v_absolutePath.empty() && "v_absolutePathɋ͎wł܂B" );
	
	//do:

	if( ! actionSettingInfo_.isAvailable() ){
		return true;
	}

	// sp[^̃Zbg
	SplitPath splitPath( v_absolutePath );	

	PropertyStringExpander expander;
	expander.addProperty( _TEXT("PATH"), v_absolutePath );
	expander.addProperty( _TEXT("DIR"), splitPath.getDirectory() );
	expander.addProperty( _TEXT("NAME"), splitPath.getFile() );
	expander.addProperty( _TEXT("NAMEBODY"), splitPath.getDirectory() );
	expander.addProperty( _TEXT("EXTENSION"), splitPath.getFileExtension() );

//			{"count",strCount},
//			{"spath",strShortName},
//			{"date",strDate},
//			{"time",strTime},
//			{"sdir",strShortDir},

	const tstring appName = expander.expandString( actionSettingInfo_.getAppName() );
	const tstring param = expander.expandString( actionSettingInfo_.getParam() );
	const tstring verb = expander.expandString( actionSettingInfo_.getAction() );
	const tstring appCurrentDir = expander.expandString( actionSettingInfo_.getAppCurrentDir() );

	SHELLEXECUTEINFO execinfo = {0};
	execinfo.cbSize = sizeof(SHELLEXECUTEINFO);
	execinfo.fMask  = SEE_MASK_CONNECTNETDRV | SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS;
	execinfo.hwnd   = NULL; //TODO: SHellhWnd
	execinfo.lpDirectory  = appCurrentDir.c_str();
	execinfo.nShow = actionSettingInfo_.getShowWindow().getShowCommand();
	execinfo.lpVerb = verb.c_str();
	execinfo.lpFile = appName.c_str();
	execinfo.lpParameters = param.c_str();

	// s
	if( ! ::ShellExecuteEx( &execinfo ) ) {
		return false;
	}

	addTraceProcessHandle( execinfo.hProcess );
	return true;
}

tstring ShellExecActionInvoker::getDescription() const throw()
{
	return tstring( _TEXT( "ShellExecute" ) );
}

