#ifndef INCLUDE_H_DATEFORMATTER
#define INCLUDE_H_DATEFORMATTER

#include "tstring.hpp"

#include <list>

/*!
 * tH[}b^̒ۊNXłB
 * tf[^當\z邽߂̈ʓIȃC^[tFCX`Ă܂B
 */
class DateFormatter
{
public:
	virtual ~DateFormatter() throw() = 0 {};
	virtual tstring format( const SYSTEMTIME& v_systime ) const throw() = 0;
};

/*!
 * tH[}b^ɂ郊ȅo͂̂߂̃tH[}b^łB
 * nf[^ɂ炸AɌŒ̕o͂܂B
 */
class LiteralDateFormatter : public DateFormatter
{
protected:
	tstring literal_;

private:
	operator=( const LiteralDateFormatter& ); //<! Ȃ
	LiteralDateFormatter( const LiteralDateFormatter& ); //<! Ȃ

public:
	LiteralDateFormatter( const tstring& v_literal );
	virtual ~LiteralDateFormatter() throw();
	virtual tstring format( const SYSTEMTIME& v_systime ) const throw();
};

/*!
 * ̗̓vftH[}bg܂B
 * tH[}bg̍ہADATEFORMATITEM_DAYOFWEEKDATEFORMATITEM_AMPM̍ڂ͐ɕϊ܂B
 * ̂ƂAw肵ɖȂꍇ͐擪0Ďw̕Ɋg܂B
 * ۂ̐̂ق傫ȏꍇ́Aۂ̐̌̂܂ܗp܂B
 * Ƃ΁ADATEFORMATITEM_DAY2w肵Ȃ1̏ꍇ́u01vƂȂA1w肵Ȃ10ł΁u10vƂȂ܂B
 * DATEFORMATITEM_DAYOFWEEḰuSUN,MON,TUE,WED,THU,FRI,SATv̂ꂩłB
 * DATEFORMATITEM_AMPḾuAM,PMv̂ꂩłB
 */
class PartDateFormatter : public DateFormatter
{
public:
	enum DATEFORMATITEM
	{
		DATEFORMATITEM_YEAR = 1,
		DATEFORMATITEM_MONTH = 2,
		DATEFORMATITEM_DAY = 3,
		DATEFORMATITEM_DAYOFWEEK = 4,
		DATEFORMATITEM_AMPM = 5,
		DATEFORMATITEM_HOUR12 = 6,
		DATEFORMATITEM_HOUR24 = 7,
		DATEFORMATITEM_MINUTE = 8,
		DATEFORMATITEM_SECOND = 9,
		DATEFORMATITEM_MILLSECOND = 10
	};

private:
	operator=( const PartDateFormatter&); //<! Ȃ
	PartDateFormatter( const PartDateFormatter& ); //<! Ȃ

protected:
	int length_;
	DATEFORMATITEM formatType_;

public:
	PartDateFormatter( DATEFORMATITEM v_formatType, int v_length );
	virtual ~PartDateFormatter() throw();
	virtual tstring format( const SYSTEMTIME& v_systime ) const throw();
};

/*!
 * Cӂ̃tH[}bgŕɕϊ܂B
 * tH[}bg̒`ƂāAy(N)AM()Ad()AE(3̗j)Aa(AM/PM)Ah(12)AH(24)Am()As(b)AS(~b)wł܂B
 * (Ea)̒u𕡐ꍇ́AŒǍ̕𖞂擪0Ŗ߂ꂽƂĕԂ܂B
 * Ǎۂ̒u鐔l(Nb́Aꂼ̒l)ꍇ́AKvȂg܂B
 * Ƃ΁Addw肵Ȃ1̏ꍇ́u01vƂȂAdw肵Ȃ10ł΁u10vƂȂ܂B
 * yyyyAyyw肵ĂN4łΏ4ƂȂ܂B(Iɏ4ƂȂ܂B)
 * E̒úuSUN,MON,TUE,WED,THU,FRI,SATv̂ꂩłB
 * a̒úuAM,PMv̂ꂩłB
 * ƂăA|XgtB(')ň͂ނƁA͂܂ꂽ͒uꂸÂ܂܏o͂܂B
 * A|XtBgo͂ꍇ''2܂B
 */
class ConfigurableDateFormatter : public DateFormatter
{
private:
	ConfigurableDateFormatter( const ConfigurableDateFormatter& ); //<! Ȃ
	operator=( const ConfigurableDateFormatter& ); //<! Ȃ

private:
	void parse( const tstring& v_format );
	void clearFormat() throw();

public:
	ConfigurableDateFormatter( const tstring& v_format );
	virtual ~ConfigurableDateFormatter() throw();
	virtual tstring format( const SYSTEMTIME& v_systime ) const throw();
	virtual bool isContainDateFormat() const throw();

private:
	typedef std::list< DateFormatter* > FormatItemList;
	FormatItemList itemList_;
	bool containDateFormatter_;
};

#endif
