#include "stdafx.hpp"

#include "PassiveTimer.hpp"

#include <assert.h>

PassiveTimer::PassiveTimer( const CFileTimeSpan& v_span, const CFileTime& v_intialStartTime, const bool v_enabled ) throw()
	: enabled_( v_enabled )
	, span_ ( v_span )
	, startTime_ ( v_intialStartTime )
{
	assert( v_span >= 0 && "v_spanɕ̒l͎wł܂B" );
}

PassiveTimer::~PassiveTimer() throw()
{
}

bool PassiveTimer::isSignaled( const CFileTime& v_now ) const throw()
{
	return enabled_ && ( ( span_ == 0 ) || ( ( v_now - startTime_ ) > span_ ) );
}

void PassiveTimer::reset( const CFileTime& v_startTime ) throw()
{
	startTime_ = v_startTime;
}

const CFileTimeSpan& PassiveTimer::getSpan() const throw()
{
	return span_;
}

void PassiveTimer::setEnable( const bool v_enabled ) throw()
{
	enabled_ = v_enabled;
}

bool PassiveTimer::isEnabled() const throw()
{
	return enabled_;
}

