#ifndef INCLUDE_H_PASSIVETIMER
#define INCLUDE_H_PASSIVETIMER

#include <atltime.h>

class PassiveTimer {
public:
	PassiveTimer( const CFileTimeSpan& v_span, const CFileTime& v_initialStartTime, const bool v_enabled ) throw();
	~PassiveTimer() throw();
	bool isSignaled( const CFileTime& v_now ) const throw();
	void reset( const CFileTime& v_startTime ) throw();
	const CFileTimeSpan& getSpan() const throw();
	void setEnable( const bool v_enabled = true ) throw();
	bool isEnabled() const throw();

private:
	bool enabled_;
	const CFileTimeSpan span_;
	CFileTime startTime_;
};

#endif
