#include "stdafx.hpp"

#include <assert.h>

#include <string>

#include "SAXContentHandlerAdaptor.hpp"
#include "SAXAttributesAdaptor.hpp"

#include "tstringUty.hpp"


SAXContentHandlerAdaptor::SAXContentHandlerAdaptor( SAXContentHandler& v_handler )
	: ref_( 1 )
	, pLocator_( NULL )
	, handler_( v_handler )
{
}

SAXContentHandlerAdaptor::~SAXContentHandlerAdaptor()
{
}

HRESULT __stdcall SAXContentHandlerAdaptor::QueryInterface(const IID& iid, void** ppvObj )
{
	if( iid == IID_IUnknown || iid == __uuidof( ISAXContentHandler ) ) {
		*ppvObj = this;
		AddRef();
		return NOERROR;
	}
	return E_NOINTERFACE;
}

ULONG __stdcall SAXContentHandlerAdaptor::AddRef(void)
{
	return ++ref_;
}

ULONG __stdcall SAXContentHandlerAdaptor::Release(void)
{
	if( --ref_ == 0 ) {
		delete this;
		return 0;
	}
	return ref_;
}

HRESULT __stdcall SAXContentHandlerAdaptor::putDocumentLocator(ISAXLocator* v_pLocator )
{
	pLocator_ = v_pLocator;
	pLocator_->AddRef();

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::startDocument(void)
{
	handler_.startDocument();

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::endDocument(void)
{
	if( pLocator_ != NULL ) {
		pLocator_->Release();
		pLocator_ = NULL;
	}

	handler_.endDocument();

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::startPrefixMapping(
	const wchar_t* pArg0,
	int arg0len,
	const wchar_t* pArg1,
	int arg1len )
{
	const std::wstring arg0( pArg0, arg0len );
	const std::wstring arg1( pArg1, arg1len );

	handler_.startPrefixMapping(
		tstringuty::getTString( arg0 ),
		tstringuty::getTString( arg1 )
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::endPrefixMapping(const wchar_t* pArg0, int arg0len )
{
	const std::wstring arg0( pArg0, arg0len );

	handler_.endPrefixMapping( tstringuty::getTString( arg0 ) );

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::startElement(
	const wchar_t* pNs,
	int nsLen,
	const wchar_t* pwchLocalName,
	int cchLocalName,
	const wchar_t* pQName,
	int QNameLen,
	ISAXAttributes* pAttr
	)
{
	std::wstring ns( pNs, nsLen );
	std::wstring localName( pwchLocalName, cchLocalName );
	std::wstring QName( pQName, QNameLen );

	const SAXAttributesAdaptor attr( pAttr );
	handler_.startElement(
		tstringuty::getTString( ns ),
		tstringuty::getTString( localName ),
		tstringuty::getTString( QName ),
		attr
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::endElement(
	const wchar_t *pNs,
	int nsLen,
	const wchar_t* pwchLocalName,
	int cchLocalName,
	const wchar_t *pQName,
	int QNameLen
	)
{
	std::wstring ns( pNs, nsLen );
	std::wstring localName( pwchLocalName, cchLocalName );
	std::wstring QName( pQName, QNameLen );

	handler_.endElement(
		tstringuty::getTString( ns ),
		tstringuty::getTString( localName ),
		tstringuty::getTString( QName )
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::characters(const wchar_t* p, int len )
{
	std::wstring chars( p, len );

	handler_.characters( tstringuty::getTString( chars ) );

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::ignorableWhitespace(const wchar_t* p, int len )
{
	std::wstring chars( p, len );

	handler_.ignorableWhitespace( tstringuty::getTString( chars ) );

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::processingInstruction(
	const wchar_t* pTarget,
	int targetLen,
	const wchar_t* pData,
	int dataLen
	)
{
	std::wstring target( pTarget, targetLen );
	std::wstring data( pData, dataLen );

	handler_.processingInstruction(
		tstringuty::getTString( target ),
		tstringuty::getTString( data )
		);

	return S_OK;
}

HRESULT __stdcall SAXContentHandlerAdaptor::skippedEntity(const wchar_t *pName, int nameLen )
{
	std::wstring name( pName, nameLen );

	handler_.skippedEntity( tstringuty::getTString( name ) );

	return S_OK;
}
