#include "stdafx.hpp"

#include "FWatchApp.hpp"
#include "resource.h"

#include "tstringUty.hpp"

#include "ShellInvokeActionSettingDialog.hpp"
#include "SettingInfoFactory.hpp"

ShellInvokeActionSettingDialog::ShellInvokeActionSettingDialog( const ActionSettingInfo& v_settingInfo ) throw()
	: hDlg_( NULL )
	, settingInfo_( v_settingInfo )
{
}

ShellInvokeActionSettingDialog::~ShellInvokeActionSettingDialog() throw()
{
}

bool ShellInvokeActionSettingDialog::show( HWND v_hParent ) throw()
{
	return ::DialogBoxParam(
		pApp->getInstanceHandle(), 
		MAKEINTRESOURCE( IDD_SHELLINVOKEACTIONDIALOG ),
		v_hParent,
		dlgProc,
		reinterpret_cast<LPARAM>( this )
		) == IDOK;
}

const ActionSettingInfo& ShellInvokeActionSettingDialog::getSettingInfo() const throw()
{
	return settingInfo_;
}

void ShellInvokeActionSettingDialog::onInitDialog() throw()
{
	assert( hDlg_ != NULL );

	hVerb = GetDlgItem( hDlg_, IDC_ACTION );
	assert( hVerb != NULL );
	hApp  = GetDlgItem( hDlg_, IDC_APPNAME );
	assert( hApp != NULL );
	hParam= GetDlgItem( hDlg_, IDC_PARAM );
	assert( hParam != NULL );
	hShowWindow = GetDlgItem( hDlg_, IDC_WINDOWSIZE );
	assert( hShowWindow != NULL );
	hMaxProcess = GetDlgItem( hDlg_, IDC_MAXPROCESS );
	assert( hMaxProcess != NULL );
	hAppCurrentDir = GetDlgItem( hDlg_, IDC_APPCURRENTDIR );
	assert( hAppCurrentDir != NULL );

	// EBhETCY̑I
	SendMessage( hShowWindow, CB_INSERTSTRING, 0, (LPARAM) ShowWindowType::valueOf( 0 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 1, (LPARAM) ShowWindowType::valueOf( 1 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 2, (LPARAM) ShowWindowType::valueOf( 2 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 3, (LPARAM) ShowWindowType::valueOf( 3 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 4, (LPARAM) ShowWindowType::valueOf( 4 ).getDescription().c_str() );

	// ANV̑I
	const tstring verbList = pApp->LoadString( IDS_SETTINGMES_VERBLIST );
	
	std::vector<tstring> verbs;
	split( verbList, '|', std::back_insert_iterator<std::vector<tstring> >(verbs) );
	for( std::vector<tstring>::iterator ite_verbs = verbs.begin();
		ite_verbs != verbs.end();
		++ite_verbs
		)
	{
		const tstring& verb = *ite_verbs;
		SendMessage( hVerb, CB_INSERTSTRING, -1, (LPARAM) verb.c_str() );
	}

	// I[gRv[g̐ݒ
	::SHAutoComplete( hApp, SHACF_DEFAULT );

	// _CAOp[^ݒ肵܂B
	setInitialParam();
}

void ShellInvokeActionSettingDialog::setInitialParam()
{
	::SendMessage( hShowWindow, CB_SETCURSEL, settingInfo_.getShowWindow(), 0 );

	setWindowText( hVerb, settingInfo_.getAction() );
	setWindowText( hApp, settingInfo_.getAppName() );
	setWindowText( hParam, settingInfo_.getParam() );
	setWindowText( hMaxProcess, tstringuty::IntToString( settingInfo_.getMaxProcess() ) );
	setWindowText( hAppCurrentDir, settingInfo_.getAppCurrentDir() );
}

void ShellInvokeActionSettingDialog::onOk() throw()
{
	ActionSettingInfoFactory factory( settingInfo_ );

	factory.setAction( getWindowText( hVerb ) );
	factory.setAppName( getWindowText (hApp ) );
	factory.setParam( getWindowText( hParam ) );
	factory.setMaxProcess( tstringuty::atoi( getWindowText( hMaxProcess ) ) );
	factory.setAppCurrentDir( getWindowText( hAppCurrentDir ) );

	LRESULT nShowWindow;
	if( ( nShowWindow = SendMessage( hShowWindow, CB_GETCURSEL, 0, 0 ) ) == CB_ERR ) {
		nShowWindow = 1;
	}
	factory.setShowWindow( ShowWindowType::valueOf( (int) nShowWindow ) );

	settingInfo_ = factory.create();

	EndDialog( hDlg_, IDOK );
}

void ShellInvokeActionSettingDialog::onCancel() throw()
{
	EndDialog( hDlg_, IDCANCEL );
}

BOOL ShellInvokeActionSettingDialog::onCommand( UINT v_id ) throw()
{
	switch( v_id ) 
	{
	case IDOK:
		onOk();
		return TRUE;

	case IDCANCEL:
		onCancel();
		return TRUE;

	default:
		break;
	}

	return FALSE;
}

INT_PTR CALLBACK ShellInvokeActionSettingDialog::dlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam ) throw()
{
#pragma warning( push )
#pragma warning( disable : 4312 4244 )

	ShellInvokeActionSettingDialog* me = reinterpret_cast<ShellInvokeActionSettingDialog*>( ::GetWindowLongPtr( hDlg, DWLP_USER ) );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( uMsg == WM_INITDIALOG ) {
		me = (ShellInvokeActionSettingDialog*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, reinterpret_cast<LONG_PTR>( me ) );
		me->hDlg_ = hDlg;
		me->onInitDialog();
		return TRUE;
	}
	else if( uMsg == WM_COMMAND ) {
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		return me->onCommand( LOWORD(wParam) );
	}

	return FALSE;

#pragma warning( pop )
}

