#include "stdafx.hpp"
#include "resource.h"
#include "FWatchApp.hpp"

#include <assert.h>

#include "TaskbarNotificationIcon.hpp"

TaskbarNotificationIcon::TaskbarNotificationIcon( HWND v_hWnd, UINT v_uID, UINT v_uMessageID, UINT v_hIconID, UINT v_uDefaultMessageID )
	: bCreated_( false )
	, hWnd_( v_hWnd )
	, uMessageID_( v_uMessageID )
	, uID_( v_uID )
	, uIconID_( v_hIconID )
	, uDefaultMessageId_( v_uDefaultMessageID )
{
}

void TaskbarNotificationIcon::Create()
{
	if(! bCreated_ ){
		ReCreate();
	}
}

void TaskbarNotificationIcon::ReCreate()
{
	icondata_.cbSize = sizeof( NOTIFYICONDATA );
	icondata_.hWnd = hWnd_;
	icondata_.uID  = uID_;
	icondata_.uFlags = NIF_ICON | NIF_TIP | NIF_MESSAGE;
	icondata_.uCallbackMessage = uMessageID_;
	icondata_.hIcon = ::LoadIcon( pApp->getInstanceHandle(), MAKEINTRESOURCE( uIconID_ ) );
	pApp->LoadString( uDefaultMessageId_, icondata_.szTip, sizeof(icondata_.szTip) );
	::Shell_NotifyIcon( NIM_ADD, &icondata_ );
	
	bCreated_ = true;
}

TaskbarNotificationIcon::~TaskbarNotificationIcon()
{
	Destroy();
}

void TaskbarNotificationIcon::Destroy()
{
	// ^XNgCACR폜
	if( bCreated_ ) {
		::Shell_NotifyIcon( NIM_DELETE, &icondata_ );
		bCreated_ = false;
	}
}

void TaskbarNotificationIcon::ShowMessage( const tstring& v_message )
{
	//required:
	assert( v_message.length() < sizeof( icondata_.szTip ) && "`bv܂B" );
	//do:
	_tcsncpy( icondata_.szTip, v_message.c_str(), sizeof( icondata_.szTip ) );
	icondata_.szTip[ sizeof( icondata_.szTip ) - 1 ] = 0;
	::Shell_NotifyIcon( NIM_MODIFY, &icondata_ );
}

void TaskbarNotificationIcon::ShowDefault()
{
	pApp->LoadString( uDefaultMessageId_, icondata_.szTip, sizeof(icondata_.szTip) );
	::Shell_NotifyIcon( NIM_MODIFY, &icondata_ );
}

