#include "stdafx.hpp"

#include <assert.h>

#include "..\FWatch\tstringUty.hpp"

void testEnsureEndsWith()
{
	assert( tstringuty::getCharCount( _TEXT("" ) ) == 0 );
	assert( tstringuty::getCharCount( _TEXT("A" ) ) == 1 );
	assert( tstringuty::getCharCount( _TEXT("AA" ) ) == 2 );
	assert( tstringuty::getCharCount( _TEXT("AA\" ) ) == 3 );
	assert( tstringuty::getCharCount( _TEXT("\\" ) ) == 2 );
	assert( tstringuty::getCharCount( _TEXT("\A\" ) ) == 3 );
	assert( tstringuty::getCharCount( _TEXT("\A\A" ) ) == 4 );
	assert( tstringuty::getCharCount( _TEXT("A\\A\\A" ) ) == 7 );

	assert( tstringuty::ensureEndsWith( _TEXT(""), _TEXT("\\") ) == _TEXT("\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("\\"), _TEXT("\\") ) == _TEXT("\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("ABC"), _TEXT("\\") ) == _TEXT("ABC\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("ABC\\"), _TEXT("\\") ) == _TEXT("ABC\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("\"), _TEXT("\\") ) == _TEXT("\\\") );
	assert( tstringuty::ensureEndsWith( _TEXT("\\\"), _TEXT("\\") ) == _TEXT("\\\") );
}
