#include "stdafx.hpp"

#include "ActionListener.hpp"

#include <assert.h>

ActionListener::ActionListener( const ActionSettingInfo& v_actionSettingInfo )
	: maxProcess_( v_actionSettingInfo.getMaxProcess() )
{
	ActionInvokerFactory actionInvokerFactory;
	pActionInvoker_ = actionInvokerFactory.create( v_actionSettingInfo );
	
	//ensure:
	assert( pActionInvoker_.get() != NULL );
}

ActionListener::~ActionListener() throw()
{
}

void ActionListener::tickEventCycle() throw()
{
	CriticalSectionLock lock( lock_ );

	if( maxProcess_ == 0 || maxProcess_ > pActionInvoker_->sweepTerminatedProcess() ) {
		invokeQueingEntry();
	}
}

void ActionListener::notifyFileEvent( EventListener::EventType v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw()
{
	if( v_eventId == EventListener::DETECT_MODIFIED ) {
		CriticalSectionLock lock( lock_ );
		if( maxProcess_ == 0 || maxProcess_ > pActionInvoker_->sweepTerminatedProcess() ) {
			if( ! invokeQueingEntry() ) {
				pActionInvoker_->createProcess( v_absolutePath, v_fileInfo );
			}
		}
		else {
			removeEntry( v_absolutePath );
			queue_.push_back( NamedFileInfoQueue::value_type( v_absolutePath, v_fileInfo ) );
		}
	}
	else if( v_eventId == EventListener::DETECT_REMOVED ) {
		CriticalSectionLock lock( lock_ );
		removeEntry( v_absolutePath );
	}
}

bool ActionListener::invokeQueingEntry() throw()
{
	CriticalSectionLock lock( lock_ );

	if( ! queue_.empty() ) {
		const NamedFileInfo namedFileInfo( queue_.front() );
		queue_.pop_front();
		pActionInvoker_->createProcess( namedFileInfo.first, namedFileInfo.second );
		return true;
	}
	return false;
}

void ActionListener::removeEntry( const tstring& v_absolutePath ) throw()
{
	CriticalSectionLock lock( lock_ );

	for( NamedFileInfoQueue::iterator ite = queue_.begin(), last = queue_.end();
		ite != last;
		)
	{
		if( ite->first == v_absolutePath ) {
			ite = queue_.erase( ite );
			break;
		}
		else {
			++ite;
		}
	}
}

tstring ActionListener::getDescription() const throw()
{
	const ActionSettingInfo& settingInfo = pActionInvoker_->getSettingInfo();
	const tstring actionTypeName = pActionInvoker_->getDescription();
	
	tstring description;
	if( ! settingInfo.isAvailable() ) {
		description += _TEXT( "<<DISABLE>> " );
	}
	else {
		description += _TEXT( "<" ) + pActionInvoker_->getDescription() + _TEXT( "> " );
		description += settingInfo.getAppName() + _TEXT(" ") + settingInfo.getParam();
	}

	return description;
}

void ActionListener::notifyStateEvent( EventListener::StateEventType v_eventId ) throw()
{
	// no action.
}

