#include "stdafx.hpp"

#include "FWatchApp.hpp"
#include "resource.h"

#include "ActionSettingInfo.hpp"

#include <assert.h>

ShowWindowType::ShowWindowType()
	: showWindowType_( ShowWindowType::NORMAL )
{
}

ShowWindowType::ShowWindowType( const int v_showWindowType )
	: showWindowType_( v_showWindowType )
{
	assert( v_showWindowType >= 0 && v_showWindowType <= 4 && "͈͊OłB" );
}

ShowWindowType::ShowWindowType( const ShowWindowType& v_other )
	: showWindowType_( v_other.showWindowType_ )
{
}

ShowWindowType& ShowWindowType::operator=( const ShowWindowType& v_other )
{
	showWindowType_ = v_other.showWindowType_;
	return *this;
}

ShowWindowType::operator int() const
{
	return showWindowType_;
}

tstring ShowWindowType::getDescription() const
{
	return pApp->LoadString( IDS_SHOWINDOWTYPE_0 + showWindowType_ );
}

int ShowWindowType::getShowCommand() const
{
	int nShowCmd = SW_SHOWNORMAL;
	switch( showWindowType_ )
	{
	case 0:
		nShowCmd = SW_SHOWMINNOACTIVE;
		break;
	case 1:
		nShowCmd = SW_SHOWNORMAL;
		break;
	case 2:
		nShowCmd = SW_SHOWMAXIMIZED;
		break;
	case 3:
		nShowCmd = SW_HIDE;
		break;
	case 4:
		nShowCmd = SW_SHOWMINIMIZED;
		break;
	default:
		break;
	}
	return nShowCmd;
}

ShowWindowType ShowWindowType::valueOf( const int v_showWindowType )
{
	if( v_showWindowType >= 0 && v_showWindowType <= 4 ) {
		return ShowWindowType( v_showWindowType );
	}
	return ShowWindowType( 1 );
}

///////////////////////////////////////////////////////

ActionSettingInfo::ActionSettingInfo()
{
	action_ = pApp->LoadString( IDS_DEFAULTPARAM_ACTION );
	param_ = pApp->LoadString( IDS_DEFAULTPARAM_PARAM );
	appCurrentDir_ = pApp->LoadString( IDS_DEFAULTPARAM_APPCURRENTDIR );
	showWindow_ = ShowWindowType::valueOf( pApp->LoadInteger( IDS_DEFAULTPARAM_SHOW ) );
	nMaxProcess_ = pApp->LoadInteger( IDS_DEFAULTPARAM_MAXPROCESS );
	appName_.clear();
}

ActionSettingInfo::ActionSettingInfo( const ActionSettingInfo& v_other )
	: action_( v_other.action_ )
	, appName_( v_other.appName_ )
	, param_( v_other.param_ )
	, showWindow_( v_other.showWindow_ )
	, nMaxProcess_( v_other.nMaxProcess_ )
	, appCurrentDir_( v_other.appCurrentDir_ )
{
}

ActionSettingInfo& ActionSettingInfo::operator=( const ActionSettingInfo& v_other )
{
	if( this != &v_other ) {
		action_ = v_other.action_;
		appName_ = v_other.appName_;
		param_ = v_other.param_;
		showWindow_ = v_other.showWindow_;
		nMaxProcess_ = v_other.nMaxProcess_;
		appCurrentDir_ = v_other.appCurrentDir_;
	}
	return *this;
}

ActionSettingInfo::~ActionSettingInfo()
{
}
