#ifndef INCLUDE_H_ACTIONSETTINGINFO
#define INCLUDE_H_ACTIONSETTINGINFO

#include "tstring.hpp"

#include <atltime.h>

/*!
 * EBhE\TCY
 */
class ShowWindowType {
private:
	/*!
	 * vCx[gRXgN^
	 * \param ID
	 */
	ShowWindowType( const int v_showWindowType );

public:

	/*!
	 * ftHglݒ肷ftHgRXgN^
	 */
	ShowWindowType();

	/*!
	 * Rs[RXgN^
	 * \param Rs[
	 */
	ShowWindowType( const ShowWindowType& v_other );

	/*!
	 * Rs[
	 * \param Rs[
	 */
	ShowWindowType& operator=( const ShowWindowType& v_other );

	/*!
	 * Ƃ肤l̈ꗗ
	 */
	enum member
	{
		MINIMIZED_NOACTIVE = 0,
		NORMAL = 1,
		MAXIMIZED = 2,
		HIDDEN = 3,
		MINIMIZED = 4
	};

	/*!
	 * int^ւ̕ϊIDԂ܂B
	 * \return ID
	 */
	operator int() const;

	/*!
	 * 擾܂B
	 * \return 
	 */
	tstring getDescription() const;

	/*!
	 * EBhEJR}hԂ܂B
	 * SW_SHOWNORMALȂǂ̒萔łB
	 * \param R}hID
	 */
	int getShowCommand() const;

	/*!
	 * IDw肵Ď擾܂B
	 * ͈͊Ȍꍇ̓ftHgԂ܂B
	 */
	static ShowWindowType valueOf( const int v_showWindowType );

	/*!
	 * ؂܂B
	 * \param rΏ
	 * \return true
	 */
	inline bool operator==( const ShowWindowType& v_other ) const
	{
		return v_other.showWindowType_ == showWindowType_;
	}

	/*!
	 * Ȃ؂܂B
	 * \param rΏ
	 * \return Ȃtrue
	 */
	inline bool operator!=( const ShowWindowType& v_other ) const
	{
		return v_other.showWindowType_ != showWindowType_;
	}

private:

	int showWindowType_;

};

/*!
 * ANV֘Aݒ
 */
class ActionSettingInfo
{
	/*!
	 * t@NgoXVł܂B
	 */
	friend class CSettingInfoFactory;
	friend class ActionSettingInfoFactory;

public:

	/*!
	 * ftHglō\z܂B
	 */
	ActionSettingInfo();

	/*!
	 * Rs[RXgN^
	 * \param v_other Rs[
	 */
	ActionSettingInfo( const ActionSettingInfo& v_other );

	/*!
	 * Rs[
	 * \param v_other Rs[
	 */
	ActionSettingInfo& operator=( const ActionSettingInfo& v_other );

	/*!
	 * fXgN^
	 */
	~ActionSettingInfo();

	/*!
	 * ANV擾܂B
	 * \return ANV
	 */
	inline tstring getAction() const {
		return action_;
	}

	/*!
	 * ANVsvO擾܂B
	 * ϐWJ܂B
	 * \return vO
	 */
	inline tstring getAppName() const {
		return appName_;
	}

	/*!
	 * ANVsvOɈnp[^擾܂B
	 * ϐWJ܂B
	 * \return p[^
	 */
	inline tstring getParam() const {
		return param_;
	}

	/*!
	 * vZX̏I҂̗L擾܂B
	 * \return vZXI܂Ŏ̃vZXNȂꍇtrue
	 */
	inline unsigned int getMaxProcess() const {
		return nMaxProcess_;
	}

	/*!
	 * vZXNƂ̃EBhETCY
	 * \return EBhETCY
	 */
	inline ShowWindowType getShowWindow() const {
		return showWindow_;
	}

	/*!
	 * AvP[Vsp̃JgfBNgB
	 * ϐWJ܂B
	 * \return JgfBNg
	 */
	inline tstring getAppCurrentDir() const {
		return appCurrentDir_;
	}

	/*!
	 * p[^Lł邩肵܂B
	 * \return Lłtrue
	 */
	inline bool isAvailable() const {
		return ! action_.empty() && ! appName_.empty();
	}

private:
	tstring action_;
	tstring appName_;
	tstring param_;
	ShowWindowType showWindow_;
	unsigned int nMaxProcess_;
	tstring appCurrentDir_;
};


#endif


