#include "stdafx.hpp"

#include "CriticalSection.hpp"

CriticalSection::CriticalSection()
{
	::InitializeCriticalSection( &criticalSection_ );
}

CriticalSection::~CriticalSection()
{
	::DeleteCriticalSection( &criticalSection_ );
}


//////


CriticalSectionLock::CriticalSectionLock( CriticalSection& v_criticalSection )
	: criticalSection_( v_criticalSection )
	, locked_( false )
{
	::EnterCriticalSection( &criticalSection_.criticalSection_ );
	locked_ = true;
}

void CriticalSectionLock::release()
{
	if( locked_ ) {
		locked_ = false;
		::LeaveCriticalSection( &criticalSection_.criticalSection_ );
	}
}

CriticalSectionLock::~CriticalSectionLock()
{
	release();
}

