// FWatch.cpp : AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "FWatchUI.hpp"
#include "ServiceEntry.hpp"
#include "SplitPath.hpp"
#include "tstringUty.hpp"

#include <assert.h>

FWatchApp::FWatchApp( HINSTANCE v_hInstance, const tstring& v_applicationName, const tstring& v_helpFile, const tstring& v_iniPath, const tstring& v_infPath )
	: ResourceAccessor( v_hInstance )
	, applicationName_( v_applicationName )
	, helpFile_( v_helpFile )
	, iniPath_( v_iniPath )
	, infPath_( v_infPath )
	, hMainWnd_( NULL )
//	, cl_( false )
{
}

FWatchApp::~FWatchApp()
{
}

LPCTSTR FWatchApp::getApplicationName() const
{
	return applicationName_.c_str();
}

HWND FWatchApp::getMainHWnd() const
{
	return hMainWnd_;
}

WatchTaskGroupCollection& FWatchApp::getWatchTaskGroupCollection()
{
	return watchTaskGroupCollection_;
}

int FWatchApp::run()
{
	// R}hC̉

	LPCTSTR cmdLine = ::GetCommandLine();
	std::vector<tstring> args;
	splitArgs( cmdLine, std::back_insert_iterator<std::vector<tstring> >( args ) );

	enum CMDTYPE
	{
		CMDTYPE_NONE     = 0,
		CMDTYPE_REGIST   = 1,
		CMDTYPE_UNREGIST = 2,
		CMDTYPE_NORMAL   = 3,
		CMDTYPE_SERVICE  = 4,
		CMDTYPE_UNKNOWN  = 9
	} cmdtyp = CMDTYPE_NONE;

	//int idx;
	//for(idx = 0 ; idx < argc ; idx++){
	//	if(argv[idx][0] == '/'){
	//		if( ! _tcsicmp( argv[ idx ], _TEXT("/service") ) )			cmdtyp = CMDTYPE_REGIST;
	//		else if( ! _tcsicmp( argv[ idx ], _TEXT("/unregister") ) )	cmdtyp = CMDTYPE_UNREGIST;
	//		else if( ! _tcsicmp( argv[ idx ], _TEXT("/noservice") ) )	cmdtyp = CMDTYPE_NORMAL;
	//		else if( ! _tcsicmp( argv[ idx ], _TEXT("/runservice" ) ) )	cmdtyp = CMDTYPE_SERVICE;
	//		else{
	//			showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_OPTION_FAIL, argv[ idx ] );
	//			return -1;
	//		}
	//	}
	//}

	//// t@C̃pXw肳Ă΃ftHg㏑܂B
	//for( idx=0; idx < argc; idx++ ) {
	//	if( argv[ idx ][ 0 ] != '/' ) {
	//		// ŏ/ȊOł͂܂t@C̃pXƂ
	//		infPath_ = argv[ idx ];
	//		break;
	//	}
	//}

	// p[^[`FbNAT[rXƂēo^邩܂B
	if( cmdtyp == CMDTYPE_REGIST ) {
		return RegistService();
	}
	else if(cmdtyp == CMDTYPE_UNREGIST ) {
		return UnregistService();
	}

	ServiceInit();

	BOOL bStartService = FALSE;
	const BOOL bRegistService = IsRegistService(bStartService);

	if( cmdtyp == CMDTYPE_SERVICE ) {
		if( ! bRegistService ) {
			pApp->showMessageBox( MB_SERVICE_NOTIFICATION | MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_SERVICENOREG );
		}
		else if( bStartService ) {
			pApp->showMessageBox( MB_SERVICE_NOTIFICATION | MB_ICONERROR | MB_OK, NULL, IDS_SERVICE_RUNNING );
		}
		else if( ! StartService() ) {
			pApp->showMessageBox( MB_SERVICE_NOTIFICATION | MB_ICONERROR | MB_OK, NULL, IDS_SERVICE_STARTERROR );
		}
	}
	else {
		FWatchUI ui;
		if( ui.create() ) {
			watchTaskGroupCollection_.load( infPath_ );
			watchTaskGroupCollection_.startWatch();

			MSG msg;
			while( GetMessage(&msg, NULL, 0, 0) ) {
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}

			watchTaskGroupCollection_.stopWatch();
		}
	}

	return 0;
}

const tstring& FWatchApp::getInfPath() const
{
	return infPath_;
}

const tstring& FWatchApp::getIniPath() const
{
	return iniPath_;
}

void FWatchApp::showHelp( HWND hWnd ) const
{
	::WinHelp( hWnd, helpFile_.c_str(), HELP_CONTENTS, 0 );
}

int FWatchApp::showMessageBox( UINT uType, LPCTSTR caption, UINT uMessageID, ... ) const
{
	va_list marker;
	va_start( marker, uMessageID );

	const tstring format = LoadString( uMessageID );

	TCHAR buffer[ 4096 ];
	wvsprintf( buffer, format.c_str(), marker );

	if( caption == NULL ) {
		caption = getApplicationName();
	}

	return ::MessageBox( NULL, buffer, caption , uType ); //TODO: MainWindow
}

FWatchAppPtr FWatchApp::createFWatchApp() throw()
{
	TCHAR nameBuf[ MAX_PATH ];
	HINSTANCE hInstance = ::GetModuleHandle( NULL );
	::LoadString( hInstance, IDS_APP_TITLE, nameBuf, MAX_PATH );

	TCHAR path[ MAX_PATH ];
	::GetModuleFileName( NULL, path, MAX_PATH );
	SplitPath splitPath( path );

	splitPath.setFileExtension( _TEXT("hlp" ) );
	const tstring helpFile = splitPath.getPath();

	splitPath.setFileExtension( _TEXT("ini" ) );
	const tstring iniPath = splitPath.getPath();

	splitPath.setFileExtension( _TEXT("lst") );
	const tstring infPath = splitPath.getPath();

	return FWatchAppPtr( new FWatchApp( hInstance, nameBuf, helpFile, iniPath, infPath) );
}

