#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "SettingInfoFactory.hpp"

#include "tstringUty.hpp"

#include <atltime.h>
#include <assert.h>

#pragma warning( disable : 4290 ) // C++ ̗O̎w͖܂B֐ __declspec(nothrow) łȂƂ̂ݕ\܂B

///

ActionSettingInfoFactory::ActionSettingInfoFactory() throw()
{
}

ActionSettingInfoFactory::ActionSettingInfoFactory( const ActionSettingInfo& v_settingInfo ) throw()
	: settingInfo_( v_settingInfo )
{
}

ActionSettingInfoFactory::ActionSettingInfoFactory( const ActionSettingInfoFactory& v_other ) throw()
	: settingInfo_( v_other.settingInfo_ )
{
}

ActionSettingInfoFactory& ActionSettingInfoFactory::operator=( const ActionSettingInfoFactory& v_other) throw()
{
	if( this != &v_other ) {
		settingInfo_ = v_other.settingInfo_;
	}
	return *this;
}

ActionSettingInfoFactory::~ActionSettingInfoFactory() throw()
{
}

void ActionSettingInfoFactory::setAction( const tstring& v_action ) throw()
{
	settingInfo_.action_ = tstringuty::trimSpaceBoth( v_action );;
}

void ActionSettingInfoFactory::setAppName( const tstring& v_appName ) throw()
{
	settingInfo_.appName_ = tstringuty::trimSpaceBoth( v_appName );
}

void ActionSettingInfoFactory::setParam( const tstring& v_param ) throw()
{
	settingInfo_.param_ = tstringuty::trimSpaceBoth( v_param );
}

void ActionSettingInfoFactory::setMaxProcess( const unsigned int v_nMaxProcess ) throw()
{
	settingInfo_.nMaxProcess_ = ( v_nMaxProcess > 0 ) ? v_nMaxProcess : 0;
}

void ActionSettingInfoFactory::setShowWindow( const ShowWindowType& v_nShowWindow ) throw()
{
	settingInfo_.showWindow_ = v_nShowWindow;
}

void ActionSettingInfoFactory::setAppCurrentDir( const tstring& v_appCurrentDir ) throw()
{
	settingInfo_.appCurrentDir_ = tstringuty::trimSpaceBoth( v_appCurrentDir );
}

bool ActionSettingInfoFactory::validate() const throw()
{
	return true;
}

const ActionSettingInfo& ActionSettingInfoFactory::create() const
{
	return settingInfo_;
}

///

CSettingInfoFactory::CSettingInfoFactory()
	: pErrorInfoListener_( NULL )
{
}

CSettingInfoFactory::CSettingInfoFactory( const TaskSettingInfo& v_settingInfo )
	: info_( v_settingInfo )
	, pErrorInfoListener_( NULL )
{
}

CSettingInfoFactory::CSettingInfoFactory( const CSettingInfoFactory& v_other )
	: info_( v_other.info_ )
	, pErrorInfoListener_( v_other.pErrorInfoListener_ )
{
}

CSettingInfoFactory& CSettingInfoFactory::operator=( const CSettingInfoFactory& v_other )
{
	if( this == &v_other ) {
		return *this;
	}

	info_ = v_other.info_;
	pErrorInfoListener_ = v_other.pErrorInfoListener_;

	return *this;
}

CSettingInfoFactory::~CSettingInfoFactory()
{
}

void CSettingInfoFactory::setErrorInfoListener( ErrorInfoListener* v_pErrorInfoListener ) throw()
{
	pErrorInfoListener_ = v_pErrorInfoListener;
}

bool CSettingInfoFactory::validate( const bool v_silent ) const
{
	bool result = true;
	if( info_.nWaitWrite_ <= 0){
		result = false;
		if( ! v_silent ) {
			notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_WAITTIME ) );
		}
	}
	if( info_.watchDir_.empty() ) {
		result = false;
		if( ! v_silent ) {
			notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_NEEDFOLDER ) );
		}
	}
	if( ! info_.bUsingNotificationAPI_ && info_.nForceInterval_ == 0 ) {
		result = false;
		if( ! v_silent ) {
			notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_UNSETDIRNOTIFICATION ) );
		}
	}

	return result;
}

TaskSettingInfo CSettingInfoFactory::create() const throw( CSettingInfoFactoryException )
{
	if( ! validate( true ) ) {
		throw CSettingInfoFactoryException( _TEXT("\zp[^sȂ߃IuWFNg쐬邱Ƃ͂ł܂B") );
	}
	return info_;
}

/*!
 * XiɃG[ʒm܂B
 * Xi̓G[󂯓ďC邱Ƃ]ޏꍇtrueԂƂł܂B
 * ̏ꍇÃ\bhtrueԂ܂B
 * Xio^ĂȂꍇ͏falseԂ܂B
 * \param G[bZ[W
 * \return G[CsꍇAtrue
 */
bool CSettingInfoFactory::notifyErrorInfo( const tstring& v_errorInfo ) const
{
	if( pErrorInfoListener_ != NULL ) {
		return pErrorInfoListener_->notifyErrorInfo( v_errorInfo );
	}
	return false;
}

void CSettingInfoFactory::setWatchDir( const tstring& v_watchDir ) throw()
{
	info_.watchDir_ = tstringuty::trimSpaceBoth( v_watchDir );
	if( ! info_.watchDir_.empty() ) {
		info_.watchDir_ = tstringuty::ensureEndsWith(
			tstringuty::trimSpaceBoth( info_.watchDir_ ), tstring( _TEXT("\\") ) );
	}
}

void CSettingInfoFactory::setWatchFile( const tstring& v_watchFile ) throw()
{
	info_.watchFile_ = tstringuty::trimSpaceBoth( v_watchFile );
	if( info_.watchFile_.empty() ) {
		info_.watchFile_ = tstring( _TEXT("*.*") );
	}
}

void CSettingInfoFactory::setPersistentFile( const tstring& v_persistentFile ) throw()
{
	info_.persistentFile_ = tstringuty::trimSpaceBoth( v_persistentFile );
}

void CSettingInfoFactory::setPersistenceDelaySpan( const CFileTimeSpan& v_persistenceDelaySpan ) throw()
{
	info_.persistenceDelaySpan_ = v_persistenceDelaySpan;
}

void CSettingInfoFactory::setWaitWrite( const CFileTimeSpan& v_waitWrite ) throw()
{
	if( v_waitWrite < 1 && ! notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_WAITTIME ) ) ) {
		return;
	}
	info_.nWaitWrite_ = ( v_waitWrite < 1 ) ? 1 : v_waitWrite;
}

void CSettingInfoFactory::setTolerance( const CFileTimeSpan& v_nTolerance ) throw()
{
	info_.nTolerance_ = ( v_nTolerance < 0 ) ? 0 : v_nTolerance;
}

void CSettingInfoFactory::setDeletePending( const CFileTimeSpan& v_deletePending ) throw()
{
	info_.nDeletePending_ = ( v_deletePending < 0 ) ? 0 : v_deletePending;
}

void CSettingInfoFactory::setMaxDepth( const int v_maxDepth )
{
	info_.nMaxDepth_ = ( v_maxDepth < 0 ) ? 0 : v_maxDepth;
}

void CSettingInfoFactory::setForceInterval( const CFileTimeSpan& v_forceInterval ) throw()
{
	if( v_forceInterval <= 0 && ! info_.bUsingNotificationAPI_ ) {
		if( ! notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_UNSETDIRNOTIFICATION ) ) ) {
			return;
		}
	}
	info_.nForceInterval_ = ( v_forceInterval <= 0 ) ? ( info_.bUsingNotificationAPI_ ? 0 : 180 ) : v_forceInterval;
}

void CSettingInfoFactory::setUsingDirNotificationAPI( const bool v_usingDirNotificationAPI ) throw()
{
	if( ! v_usingDirNotificationAPI && info_.nForceInterval_ <= 0 ) {
		if( ! notifyErrorInfo( pApp->LoadString( IDS_SETTINGMES_UNSETDIRNOTIFICATION ) ) ) {
			return;
		}
		info_.nForceInterval_ = CFileTimeSpan( 180 * 1000 * 10000 );
	}
	info_.bUsingNotificationAPI_ = v_usingDirNotificationAPI;
}

void CSettingInfoFactory::setDirNotificationAPIRetryInterval( const CFileTimeSpan& v_dirNotificationAPIRetryInterval ) throw()
{
	info_.nDirNotificationAPIRetryInterval_ = ( v_dirNotificationAPIRetryInterval < 0 ) ? 0 : v_dirNotificationAPIRetryInterval;
}

void CSettingInfoFactory::setDirNotificationAPIExpirySpan( const CFileTimeSpan& v_dirNotificationAPIExpirySpan ) throw()
{
	info_.nDirNotificationAPIExpirySpan_ = ( v_dirNotificationAPIExpirySpan < 0 ) ? 0 : v_dirNotificationAPIExpirySpan;
}

void CSettingInfoFactory::setDelaySignalSpan( const CFileTimeSpan& v_delaySignalSpan ) throw()
{
	info_.delaySignalSpan_ = ( v_delaySignalSpan < 0 ) ? 0 : v_delaySignalSpan;
}


