#include "stdafx.hpp"
#include "resource.h"
#include "FWatchApp.hpp"
#include "TaskSettingDialog.hpp"

#include "Utility.hpp"
#include "tstringUty.hpp"

#include <assert.h>

#include <shlobj.h>
#include <shlwapi.h>

#include <vector>

TaskSettingDialog::TaskSettingDialog( const TaskSettingInfo& v_settingInfo )
	: hDlg_( NULL )
	, settingInfo_( v_settingInfo )
	, factory_( v_settingInfo )
	, errorOccured_( false )
{
}

TaskSettingDialog::~TaskSettingDialog()
{
}

bool TaskSettingDialog::show( HWND hWnd )
{
	return ::DialogBoxParam(
		pApp->getInstanceHandle(),
		MAKEINTRESOURCE( IDD_TASKSETTINGDIALOG ),
		hWnd,
		DlgProc,
		(LPARAM)this
		) == IDOK;
}

/*!
 * t@Ngp[^̐ݒɉ߂邽тɃG[ʒm܂B
 * ߂lƂfalsew肷ƃp[^͐ݒ肳܂B
 * truew肷ƁA񕜂łꍇ͉񕜂ăp[^ݒ肳܂B
 * Ap[^̉񕜂łȂꍇfalseƓłB
 * \param v_errorInfo G[
 * \return 񕜂ꍇtruew肵܂B
 */
bool TaskSettingDialog::notifyErrorInfo( const tstring& v_errorInfo ) throw()
{
	const tstring errorCaption = pApp->LoadString( IDS_ERROR_SETTING );
	errorOccured_ = true;
	::MessageBox( hDlg_, v_errorInfo.c_str(), errorCaption.c_str(), MB_ICONERROR | MB_OK );
	return false;
}

TaskSettingInfo TaskSettingDialog::createSettingInfo() const
{
	try{
		return factory_.create();
	}
	catch( const CSettingInfoFactory::CSettingInfoFactoryException& ) {
		assert( false && "p[^̍\zɎs܂Bshow\bhIɌĂяo\܂B" );
		throw;
	}
}

void TaskSettingDialog::OnInitDialog()
{
	assert( hDlg_ != NULL );

	hDir  = GetDlgItem( hDlg_, IDC_WATCHDIR );
	assert( hDir != NULL );
	hName = GetDlgItem( hDlg_, IDC_FILETYPE );
	assert( hName != NULL );
	hMaxDepth = GetDlgItem( hDlg_, IDC_MAXDEPTH );
	assert( hMaxDepth != NULL );

	hWaitWrite = GetDlgItem( hDlg_, IDC_WAITWRITABLE );
	assert( hWaitWrite != NULL );
	hTolerance = GetDlgItem( hDlg_, IDC_TOLERANCE );
	assert( hTolerance != NULL );
	hDeletePending = GetDlgItem( hDlg_, IDC_DELETEPENDING );
	assert( hDeletePending != NULL );

	hDirNotificationAPIRetrySpan = GetDlgItem( hDlg_, IDC_DIRNOTIFICATIONAPIRETRYSPAN );
	assert( hDirNotificationAPIRetrySpan != NULL );
	hDirNotificationAPIExpirySpan = GetDlgItem( hDlg_, IDC_DIRNOTIFICATIONAPIRETRYEXPIRYSPAN );
	assert( hDirNotificationAPIExpirySpan != NULL );
	hForceInterval = GetDlgItem( hDlg_, IDC_FORCEINTERVAL );
	assert( hForceInterval != NULL );
	hDelaySignalSpan = GetDlgItem( hDlg_, IDC_DELAYSIGNALSPAN );
	assert( hDelaySignalSpan != NULL );

	hPersistentFile = GetDlgItem( hDlg_, IDC_PERSISTENTFILE );
	assert( hPersistentFile != NULL );
	hPersistenceDelaySpan = GetDlgItem( hDlg_, IDC_PERSISTENCEDELAYSPAN );
	assert( hPersistenceDelaySpan != NULL );

	// I[gRv[g̐ݒ
	::SHAutoComplete( hDir, SHACF_FILESYSTEM );
	::SHAutoComplete( hPersistentFile, SHACF_FILESYSTEM );

	// _CAOp[^ݒ肵܂B
	setInitialParam();

	// t@Ng̃G[ʒmÃ_CAO󂯂܂B
	factory_.setErrorInfoListener( this );
}

void TaskSettingDialog::setInitialParam()
{
	setWindowText( hDir, settingInfo_.getWatchDir() );
	setWindowText( hName, settingInfo_.getWatchFile() );
	setWindowText( hMaxDepth, tstringuty::IntToString( settingInfo_.getMaxDepth() ) );

	setWindowText( hPersistentFile, settingInfo_.getPersistentFile() );
	setWindowText( hPersistenceDelaySpan, tstringuty::Int64ToString( settingInfo_.getPersistenceDelaySpan().GetTimeSpan() / ( 1000 * 10000 ) ) );

	setWindowText( hTolerance, tstringuty::Int64ToString( settingInfo_.getTolerance().GetTimeSpan() / 10000 ) );
	setWindowText( hWaitWrite, tstringuty::Int64ToString( settingInfo_.getWaitWrite().GetTimeSpan() / ( 100 * 10000 ) ) );
	setWindowText( hDeletePending, tstringuty::Int64ToString( settingInfo_.getDeletePending().GetTimeSpan() / ( 100 * 10000 ) ) );

	::CheckDlgButton( hDlg_, IDC_USEDIRNITIFICATIONAPI, settingInfo_.isUsingDirNotificationAPI() ? BST_CHECKED : BST_UNCHECKED );

	setWindowText( hDirNotificationAPIRetrySpan, tstringuty::Int64ToString( settingInfo_.getDirNotificationAPIRetryInterval().GetTimeSpan() / ( 1000 * 10000 ) ) );
	setWindowText( hDirNotificationAPIExpirySpan, tstringuty::Int64ToString( settingInfo_.getDirNotificationAPIExpirySpan().GetTimeSpan() / ( 1000 * 10000 ) ) );
	setWindowText( hForceInterval, tstringuty::Int64ToString( settingInfo_.getForceInterval().GetTimeSpan() / ( 1000 * 10000 ) ) );

	setWindowText( hDelaySignalSpan, tstringuty::Int64ToString( settingInfo_.getDelaySignalSpan().GetTimeSpan() / 10000 ) );
}

void TaskSettingDialog::onOK()
{
	clearError();

	factory_.setWatchDir( getWindowText( hDir ) );
	factory_.setWatchFile( getWindowText( hName ) );

	factory_.setWaitWrite( tstringuty::atoi( getWindowText( hWaitWrite ) ) * 100 * 10000 );
	factory_.setTolerance( tstringuty::atoi( getWindowText( hTolerance ) ) * 10000 );

	factory_.setDeletePending( tstringuty::atoi( getWindowText( hDeletePending ) ) * 100 * 10000 );
	factory_.setDelaySignalSpan( tstringuty::atoi( getWindowText( hDelaySignalSpan ) ) * 10000 );

	factory_.setPersistentFile( getWindowText( hPersistentFile ) );
	factory_.setPersistenceDelaySpan( tstringuty::atoi( getWindowText( hPersistenceDelaySpan ) ) * 1000 * 10000 );

	const int forceInterval = tstringuty::atoi( getWindowText( hForceInterval ) ) * 1000 * 10000;
	if( forceInterval > 0 ) {
		factory_.setForceInterval( forceInterval );
		factory_.setUsingDirNotificationAPI( ( IsDlgButtonChecked( hDlg_, IDC_USEDIRNITIFICATIONAPI ) == BST_CHECKED ) ? true : false );
	}
	else {
		factory_.setUsingDirNotificationAPI( ( IsDlgButtonChecked( hDlg_, IDC_USEDIRNITIFICATIONAPI ) == BST_CHECKED ) ? true : false );
		factory_.setForceInterval( forceInterval );
	}

	factory_.setDirNotificationAPIRetryInterval( tstringuty::atoi( getWindowText( hDirNotificationAPIRetrySpan ) ) * 1000 * 10000 );
	factory_.setDirNotificationAPIExpirySpan( tstringuty::atoi( getWindowText( hDirNotificationAPIExpirySpan ) ) * 1000 * 10000 );

	factory_.setMaxDepth( tstringuty::atoi( getWindowText( hMaxDepth ) ) );

	if( ! isErrorOccured() && factory_.validate( false ) ) {
		EndDialog(hDlg_,IDOK);
	}
}

void TaskSettingDialog::onCancel()
{
	EndDialog(hDlg_,IDCANCEL);
}

void TaskSettingDialog::onBrowseDir()
{
	IMalloc* g_pMalloc = NULL;
	if( FAILED( ::SHGetMalloc( &g_pMalloc ) ) ) {
		pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_SHELLALLOCERROR );
		return;
	}

	const tstring caption = pApp->LoadString( IDS_SETTINGMES_SELECTDIR );
	
	TCHAR dirname[MAX_PATH];

	BROWSEINFO bi = {0};
	bi.hwndOwner = hDlg_;
	bi.pidlRoot = NULL;
	bi.pszDisplayName = dirname;
	bi.lpszTitle = caption.c_str();
	bi.ulFlags = BIF_RETURNONLYFSDIRS;
	bi.lpfn = NULL;
	bi.lParam = NULL;
	bi.iImage = 0;
	LPITEMIDLIST pidlist = ::SHBrowseForFolder( &bi );
	if( pidlist ){
		if( ::SHGetPathFromIDList( pidlist, dirname ) ) {
			TrimSpaceBothBuff( dirname );
			EnsureEndsWithBuff( dirname, _TEXT("\\") );
			setWindowText(hDir, dirname );
		}
		g_pMalloc->Free( pidlist );
	}
	g_pMalloc->Release();
}

void TaskSettingDialog::onSavePersistent()
{
	tstring filter = pApp->LoadString( IDS_SETTINGMES_PERSISTENTFILE );
	tstring::size_type pos;
	while( ( pos = filter.find( '|' ) ) != tstring::npos ) {
		filter.replace( pos, 1, 1, '\0' );
	}
	filter.push_back( '\0' );

	TCHAR savename[MAX_PATH] = { 0 };
	OPENFILENAME ofn = {0};
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg_;
	ofn.hInstance = pApp->getInstanceHandle();
	ofn.lpstrFilter = filter.data();
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = savename;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST;
	ofn.lpstrDefExt = _TEXT("fwatch_persistence");
	if( ::GetSaveFileName( &ofn ) ){
		setWindowText( hPersistentFile, savename );
	}
}

//void TaskSettingDialog::onLogSelect()
//{
//	tstring filter = pApp->LoadString( IDS_SETTINGMES_LOGFILEFILTER );
//	tstring::size_type pos;
//	while( ( pos = filter.find( '|' ) ) != tstring::npos ) {
//		filter.replace( pos, 1, 1, '\0' );
//	}
//	filter.push_back( '\0' );
//
//	TCHAR savename[MAX_PATH] = { 0 };
//	OPENFILENAME ofn = {0};
//	ofn.lStructSize = sizeof(OPENFILENAME);
//	ofn.hwndOwner = hDlg_;
//	ofn.hInstance = pApp->getInstanceHandle();
//	ofn.lpstrFilter = filter.data();
//	ofn.lpstrCustomFilter = NULL;
//	ofn.nMaxCustFilter = 0;
//	ofn.nFilterIndex = 0;
//	ofn.lpstrFile = savename;
//	ofn.nMaxFile = MAX_PATH;
//	ofn.lpstrInitialDir = NULL;
//	ofn.lpstrTitle = NULL;
//	ofn.Flags = OFN_FILEMUSTEXIST;
//	ofn.lpstrDefExt = _TEXT("log");
//	if( ::GetSaveFileName( &ofn ) ){
//		setWindowText( hLog, savename );
//	}
//}

BOOL TaskSettingDialog::onCommand( UINT btn )
{
	switch(btn)
	{
	case IDOK:
		onOK();
		break;
		
	case IDCANCEL:
		onCancel();
		break;

	case IDC_BROWSE:
		onBrowseDir();
		break;

	case IDC_SAVE_PERSISTENT:
		onSavePersistent();
		break;

	default:
		return FALSE;
	}
	
	return TRUE;
}

INT_PTR CALLBACK TaskSettingDialog::DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
#pragma warning( push )
#pragma warning( disable : 4312 4244 )

	TaskSettingDialog* me = reinterpret_cast<TaskSettingDialog*>( ::GetWindowLongPtr( hDlg, DWLP_USER ) );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( message == WM_INITDIALOG ) {
		me = (TaskSettingDialog*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, reinterpret_cast<LONG_PTR>( me ) );
		me->hDlg_ = hDlg;
		me->OnInitDialog();
		return TRUE;
	}
	else if( message == WM_COMMAND ) {
		return me->onCommand( LOWORD(wParam) );
	}

	return FALSE;

#pragma warning( pop )
}

