#if !defined(CSETTINGDLG_HEADER)
#define CSETTINGDLG_HEADER

#include "SettingInfo.hpp"
#include "SettingInfoFactory.hpp"

#include "WindowUtility.hpp"

#include "tstring.hpp"

/*!
 * Ďp[^̐ݒp_CAO
 */
class TaskSettingDialog : protected CSettingInfoFactory::ErrorInfoListener, protected WindowUtility
{
private:
	TaskSettingDialog( const TaskSettingDialog& ); //<! Ȃ
	operator=( const TaskSettingDialog& ); //<! Ȃ

public:
	/*!
	 * ƂȂ鐳Ďp[^w肵č\z܂B
	 * \param v_settingInfo Ďp[^
	 */
	TaskSettingDialog( const TaskSettingInfo& v_settingInfo );

	/*!
	 * fXgN^
	 */
	virtual ~TaskSettingDialog();

	/*!
	 * _CAO\܂B
	 * \return ͂ꂽꍇtrue
	 */
	bool show(HWND hWnd );

	/*!
	 * p[^\z܂B
	 * ̃\bhshow\bhIĂȂꍇ͌ĂяoĂ͂Ȃ܂B
	 * \param p[^
	 */
	TaskSettingInfo createSettingInfo() const;

protected:

	/*!
	 * t@Ngp[^̐ݒɉ߂邽тɃG[ʒm܂B
	 * ߂lƂfalsew肷ƃp[^͐ݒ肳܂B
	 * truew肷ƁA񕜂łꍇ͉񕜂ăp[^ݒ肳܂B
	 * Ap[^̉񕜂łȂꍇfalseƓłB
	 * \param v_errorInfo G[
	 * \return 񕜂ꍇtruew肵܂B
	 */
	virtual bool notifyErrorInfo( const tstring& v_errorInfo ) throw();

private:

	/*!
	 * ƂȂp[^_CAÕRg[ɔzu܂B
	 */
	void setInitialParam();

	/*!
	 * _CAOꂽƂɌĂяonhB
	 */
	void OnInitDialog();

	/*!
	 * R}hnh
	 */
	BOOL onCommand( UINT btn );

	/*!
	 * OK{^̃nhB
	 * _CAO͍̓ڂłꍇ̂݃_CAOI܂B
	 */
	void onOK();

	/*!
	 * CANCEL{^̃nhB
	 * _CAO̓͂LZI܂B
	 */
	void onCancel();

	/*!
	 * ĎtH_Inh
	 */
	void onBrowseDir();

	/*!
	 * ĎԂ̕ۑInh
	 */
	void onSavePersistent();

private:

	/*!
	 * t@Ng̃G[ʒmH
	 * \param G[Ăꍇtrue
	 */
	inline bool isErrorOccured() const
	{
		return errorOccured_;
	}

	/*!
	 * G[NA܂B
	 */
	void clearError()
	{
		errorOccured_ = false;
	}

	/*!
	 * p[^
	 */
	TaskSettingInfo settingInfo_;

	/*!
	 * t@Ng
	 */
	CSettingInfoFactory factory_;

	/*!
	 * t@NgG[ʒmꂽtO
	 */
	bool errorOccured_;

	/*!
	 * ̃_CAÕEBhEnhB
	 * ̓_CAOvV[WɂďCxg̑Oɐݒ肳܂B
	 */
	HWND hDlg_;

	/* ȉOnInitDialogŐݒ肳qRg[ */

	HWND hDir;
	HWND hName;

	HWND hWaitWrite;
	HWND hTolerance;
	HWND hDeletePending;
	
	HWND hMaxDepth;
	HWND hDirNotificationAPIRetrySpan;
	HWND hDirNotificationAPIExpirySpan;
	HWND hForceInterval;

	HWND hDelaySignalSpan;

	HWND hPersistentFile;
	HWND hPersistenceDelaySpan;

	/*!
	 * _CAOvV[W
	 */
	static INT_PTR CALLBACK DlgProc(HWND,UINT,WPARAM,LPARAM);
};

#endif
