#include "stdafx.hpp"
#include "resource.h"

#include "FWatchApp.hpp"

#include "tstringUty.hpp"

#include "WatchTaskGroup.hpp"

#include <assert.h>

#include <fstream>
#include <exception>

//////////////////////////////////////////////

WatchTaskGroup::WatchTaskGroup( const bool v_dryrun, const ThreadGroupProfile& v_threadGroupProfile )
	: modified_( false )
	, dryrun_( v_dryrun )
	, multiTask_( v_threadGroupProfile )
	, EventDispatcher( _TEXT( "WatchTaskGroup EventDispatcher" ) )
{
}

WatchTaskGroup::iterator WatchTaskGroup::begin()
{
	if( taskList_.empty() ) {
		return NULL;
	}
	return &taskList_[ 0 ];
}

WatchTaskGroup::const_iterator WatchTaskGroup::begin() const
{
	if( taskList_.empty() ) {
		return NULL;
	}
	return &taskList_[ 0 ];
}

WatchTaskGroup::iterator WatchTaskGroup::end()
{
	if( taskList_.empty() ) {
		return NULL;
	}
	return &taskList_[ 0 ] + taskList_.size();
}

WatchTaskGroup::const_iterator WatchTaskGroup::end() const
{
	if( taskList_.empty() ) {
		return NULL;
	}
	return &taskList_[ 0 ] + taskList_.size();
}


void WatchTaskGroup::clear()
{
	multiTask_.resetSchedule();

	// ׂẴ^XNjB
	for( WatchTaskList::iterator ite = taskList_.begin();
		ite != taskList_.end();
		++ite )
	{
		WatchTask* pWatchTask = *ite;
		delete pWatchTask;
	}
	taskList_.clear();

	modified_ = false;
}

WatchTaskGroup::~WatchTaskGroup()
{
	clear();
}

bool WatchTaskGroup::isDryRun() const
{
	return dryrun_;
}

void WatchTaskGroup::startWatch()
{
	//required:
	assert( ! multiTask_.isScheduling() && "Xbh͂łɎsłB" );

	//do:
	if( ! dryrun_ ) {
		multiTask_.startSchedule();
	}
}

void WatchTaskGroup::stopWatch()
{
	if( ! dryrun_ ) {
		multiTask_.stopSchedule();
	}
}

bool WatchTaskGroup::isModified() const
{
	return modified_;
}

unsigned int WatchTaskGroup::size() const
{
	return (unsigned int) taskList_.size();
}

const TaskSettingInfo& WatchTaskGroup::operator[]( size_t idx ) const
{
	//required:
	assert( idx >= 0 && idx < taskList_.size() && "݂ȂACeɂ̓ANZXł܂B" );
	
	//do:
	return taskList_[ idx ]->getSettingInfo();
}

WatchTask* WatchTaskGroup::createWatchTaskInternal( const TaskSettingInfo& v_settingInfo )
{
	WatchTask *const pWatchTask = new WatchTask( v_settingInfo );
	pWatchTask->appendEventListener( this );
	return pWatchTask;
}

WatchTask* WatchTaskGroup::createWatchTask( const TaskSettingInfo& v_settingInfo )
{
	WatchTask *const pWatchTask = createWatchTaskInternal( v_settingInfo );

	taskList_.push_back( pWatchTask );
	bool result = true;
	if( ! dryrun_ ) {
		result = multiTask_.appendTask( pWatchTask, false );
	}
	modified_ = true;
	assert( result && "^XN̒ǉɎs܂B" );

	return pWatchTask;
}
/*!
 * ^XÑCfbNX擾܂B
 * ݂Ȃꍇ-1Ԃ܂B
 */
size_t WatchTaskGroup::find( const WatchTask* v_pWatchTask ) const
{
	assert( v_pWatchTask != NULL );

	int idx = 0;
	for( WatchTaskList::const_iterator ite = taskList_.begin(), last = taskList_.end();
		ite != last;
		++ite, ++idx )
	{
		if( v_pWatchTask == *ite ) {
			return idx;
		}
	}
	return -1;
}

WatchTask* WatchTaskGroup::replace( size_t idx, const TaskSettingInfo& v_settingInfo )
{
	//required:
	assert( idx >= 0 && idx < taskList_.size() && "݂ȂACeɂ̓ANZXł܂B" );
	
	//do:

	WatchTask* pOldWatchTask = taskList_[ idx ];
	multiTask_.removeTask( pOldWatchTask );
	delete pOldWatchTask;

	WatchTask *const pWatchTask = createWatchTaskInternal( v_settingInfo );
	taskList_[ idx ] = pWatchTask;

	bool result = true;
	if( ! dryrun_ ) {
		result = multiTask_.appendTask( pWatchTask, false );
	}
	modified_ = true;
	assert( result && "^XN̍ւɎs܂B" );

	return pWatchTask;
}

size_t WatchTaskGroup::erase( size_t idx )
{
	//required:
	assert( idx >= 0 && idx < taskList_.size() && "͈͊OłB" );

	//do:
	WatchTaskList::iterator ite = taskList_.begin() + idx;
	WatchTask* pWatchTask = *ite;
	const bool result = multiTask_.removeTask( pWatchTask );
	delete pWatchTask;
	taskList_.erase( ite );

	modified_ = true;
	assert( result && "^XN̍폜Ɏs܂B" );

	return idx;
}

bool WatchTaskGroup::isRunning() const
{
	return multiTask_.isScheduling();
}

/*!
 * XbhO[vvt@C̎擾
 */
const ThreadGroupProfile& WatchTaskGroup::getThreadGroupProfile() const
{
	return multiTask_.getThreadGroupProfile();
}

/*!
 * XbhO[vvt@C̐ݒ
 */
void WatchTaskGroup::setThreadGroupProfile( const ThreadGroupProfile& v_profile )
{
	multiTask_.setThreadGroupProfile( v_profile );
	modified_ = true;
}
