#include "stdafx.hpp"

#include <assert.h>
#include "..\FWatch\DateFormatter.hpp"

void testDateFormater()
{
	SYSTEMTIME systime = { 0 };
	systime.wYear = 2005;
	systime.wMonth = 5;
	systime.wDay = 1;
	systime.wDayOfWeek = 0;
	systime.wHour = 20;
	systime.wMinute = 30;
	systime.wSecond = 40;
	systime.wMilliseconds = 999;

	tstring tmp;

	ConfigurableDateFormatter fmt1( _TEXT("'literal'") );
	tmp = fmt1.format( systime );
	assert( tmp == _TEXT("literal") );

	ConfigurableDateFormatter fmt12( _TEXT("e̕\A:'literalA'") );
	tmp = fmt12.format( systime );
	assert( tmp == _TEXT("e̕\A:literalA") );

	ConfigurableDateFormatter fmt2( _TEXT("yyyy/MM/dd HH:mm:ss") );
	tmp = fmt2.format( systime );
	assert( tmp == _TEXT("2005/05/01 20:30:40") );

	ConfigurableDateFormatter fmt3( _TEXT("'LITERAL AND TIME=('yyyy/MM/dd(E) ahh:mm:ss.SSS').'") );
	tmp = fmt3.format( systime );
	assert( tmp == _TEXT("LITERAL AND TIME=(2005/05/01(SUN) PM08:30:40.999).") );
}

