#include "stdafx.hpp"

#include <assert.h>
#include <fstream>
#include <vector>

#include "..\FWatch\XMLWriter.hpp"

void testXMLWriter()
{
	XMLWriterFactory factory;
	XMLWriterPtr xmlWriter = factory.create( _TEXT("output_test.xml") );
	SAXAttributesHolderPtr attr = xmlWriter->createAttributesHolder();
	
	xmlWriter->startDocument();

	xmlWriter->startElement( _TEXT(""), _TEXT("root"), _TEXT("root"), *attr );
	xmlWriter->startElement( _TEXT(""), _TEXT("params"), _TEXT("params"), *attr );

	attr->clear();
	attr->addAttribute( _TEXT(""), _TEXT("name"), _TEXT("name"), _TEXT("ENTITY"), _TEXT("ABC") );
	attr->addAttribute( _TEXT(""), _TEXT("value"), _TEXT("value"), _TEXT("ENTITY"), _TEXT("123") );
	xmlWriter->startElement( _TEXT(""), _TEXT("param"), _TEXT("param"), *attr );
	xmlWriter->endElement( _TEXT(""), _TEXT("param"), _TEXT("param") );

	attr->clear();
	attr->addAttribute( _TEXT(""), _TEXT("name"), _TEXT("name"), _TEXT("ENTITY"), _TEXT("") );
	attr->addAttribute( _TEXT(""), _TEXT("value"), _TEXT("value"), _TEXT("ENTITY"), _TEXT("`{`") );
	xmlWriter->startElement( _TEXT(""), _TEXT("param"), _TEXT("param"), *attr );
	xmlWriter->endElement( _TEXT(""), _TEXT("param"), _TEXT("param") );

	xmlWriter->endElement( _TEXT(""), _TEXT("params"), _TEXT("params") );

	xmlWriter->startElement( _TEXT(""), _TEXT("param2"), _TEXT("param2"), *attr );
	xmlWriter->characters( _TEXT("C:\\TEMP\\ABC.TXT") );
	xmlWriter->endElement( _TEXT(""), _TEXT("param2"), _TEXT("param2") );

	xmlWriter->endElement( _TEXT(""), _TEXT("root"), _TEXT("root") );
	xmlWriter->endDocument();
	xmlWriter.reset();

	std::vector< std::string > outputBuf;
	std::string line;

	std::ifstream fin( "output_test.xml" );
	assert( fin.is_open() && "t@C݂ȂJ܂B" );
	while( std::getline( fin, line ) ) {
		outputBuf.push_back( line );
	}
	fin.close();

	std::vector<std::string>::const_iterator ite = outputBuf.begin();

	std::ifstream finOrg( "output_test.xml.org" );
	assert( finOrg.is_open() );
	while( std::getline( finOrg, line ) ) {
		assert( line == *ite && "XML\t@C̓eƈv܂B" );
		++ite;
	}
	finOrg.close();

	assert( ite == outputBuf.end() && "I[v܂B" );
}

