#include "stdafx.hpp"

#include "AbstractExecuteActionInvoker.hpp"

#include <assert.h>

AbstractExecuteActionInvoker::AbstractExecuteActionInvoker( const ExecuteActionSettingInfo& v_actionSettingInfo ) throw()
	: actionSettingInfo_( v_actionSettingInfo )
{
}

AbstractExecuteActionInvoker::~AbstractExecuteActionInvoker() throw()
{
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end();
		++ite )
	{
		HANDLE hProcess = *ite;
		::CloseHandle( hProcess );
	}
	processHandleList_.clear();
}

unsigned int AbstractExecuteActionInvoker::sweepTerminatedProcess() throw()
{
	unsigned int count = 0;
	for( ProcessHandleList::iterator ite = processHandleList_.begin();
		ite != processHandleList_.end(); )
	{
		HANDLE hProcess = *ite;
		const DWORD ret = ::WaitForSingleObject( hProcess, 0 );
		if( ret != WAIT_TIMEOUT ) {
			// vZXIĂȂƂmłȂΏIĂƂ݂ȂB
			::CloseHandle( hProcess );
			ite = processHandleList_.erase( ite );
		}
		else {
			count++;
			++ite;
		}
	}
	return count;
}

void AbstractExecuteActionInvoker::addTraceProcessHandle( HANDLE v_hProcess ) throw()
{
	if( v_hProcess == NULL ) {
		return;
	}

	if( actionSettingInfo_.getMaxProcess() > 0 ) {
		processHandleList_.push_back( v_hProcess );
	}
	else {
		// Ȃ̂ŒǐՂ̕KvȂ
		::CloseHandle( v_hProcess );
	}
}

const ActionSettingParameter& AbstractExecuteActionInvoker::getSettingInfo() const throw()
{
	return actionSettingInfo_.getParameters();
}
