#ifndef INCLUDE_H_ACTIONINVOKERFACTORY
#define INCLUDE_H_ACTIONINVOKERFACTORY

#include "ActionInvoker.hpp"
#include "ActionSettingParameter.hpp"

#include "tstring.hpp"

/*!
 * ActionInvoker̃t@Ng
 */
class ActionInvokerFactory {
protected:
	virtual ~ActionInvokerFactory() = 0 {}

public:
	virtual void addRef() = 0;
	virtual void release() = 0;
	virtual LPCTSTR getActionType() const = 0;
	virtual LPCTSTR getDescription() const = 0;
	virtual ActionInvokerPtr create( const ActionSettingParameter& v_actionSettingParameter ) const = 0;
	virtual const ActionSettingParameter& getDefaultParameter() const = 0;
	virtual bool showEditParameter( HWND v_parent, ActionSettingParameter& ) const = 0;
};

#endif
