#include "stdafx.hpp"

#include "ActionInvokerFactoryManager.hpp"

#include <assert.h>

ActionInvokerFactoryManager::ActionInvokerFactoryManager()
{
}

ActionInvokerFactoryManager::~ActionInvokerFactoryManager()
{
	for( ActionInvokerFactoryMap::iterator ite = actionInvokerFactories_.begin();
		ite != actionInvokerFactories_.end();
		++ite )
	{
		ActionInvokerFactory* factory = ite->second;
		factory->release();
	}
}

ActionInvokerFactory* ActionInvokerFactoryManager::getFactory( const tstring& v_actionType ) const
{
	ActionInvokerFactoryMap::const_iterator ite = actionInvokerFactories_.find( v_actionType );
	if( ite != actionInvokerFactories_.end() ) {
		return ite->second;
	}
	return NULL;
}

void ActionInvokerFactoryManager::appendFactory( ActionInvokerFactory* const v_factory, const bool v_addRef )
{
	//required:
	assert( v_factory != NULL );
	
	//do:
	const tstring actionType = v_factory->getActionType();
	assert( ! actionType.empty() );

	if( actionInvokerFactories_.insert( ActionInvokerFactoryMap::value_type( actionType, v_factory ) ).second ) {
		if( v_addRef ) {
			v_factory->addRef();
		}
	}
}

void ActionInvokerFactoryManager::remove( const tstring& v_actionType )
{
	actionInvokerFactories_.erase( v_actionType );
}

