#include "stdafx.hpp"

#include "ActionListenerFactoryManagerImpl.hpp"

#include <assert.h>


ActionListenerFactoryManagerImpl::ActionListenerFactoryManagerImpl() throw()
{
}

ActionListenerFactoryManagerImpl::~ActionListenerFactoryManagerImpl() throw()
{
}

void ActionListenerFactoryManagerImpl::appendActionListenerFactory( ActionListenerFactory* v_factory ) throw()
{
	assert( v_factory != NULL );

	listenerFactories_.push_back( v_factory );
}

void ActionListenerFactoryManagerImpl::removeActionListenerFactory( ActionListenerFactory* v_factory ) throw()
{
	for( ActionListenerFactoryList::iterator ite = listenerFactories_.begin();
		ite != listenerFactories_.end();
		)
	{
		ActionListenerFactory* pListenerFactory = *ite;
		assert( pListenerFactory != NULL );
		if( pListenerFactory == v_factory ) {
			pListenerFactory->release();
			ite = listenerFactories_.erase( ite );
		}
		else {
			++ite;
		}
	}
}

ActionListenerFactoryManagerImpl::size_type ActionListenerFactoryManagerImpl::size() const throw()
{
	return listenerFactories_.size();
}

bool ActionListenerFactoryManagerImpl::empty() const throw()
{
	return listenerFactories_.empty();
}

ActionListenerFactoryManagerImpl::const_iterator ActionListenerFactoryManagerImpl::begin() const throw()
{
	return listenerFactories_.begin();
}

ActionListenerFactoryManagerImpl::const_iterator ActionListenerFactoryManagerImpl::end() const throw()
{
	return listenerFactories_.end();
}

