#ifndef INCLUDE_H_FWATCHSETTINGDLG
#define INCLUDE_H_FWATCHSETTINGDLG

#include "DialogLayoutExpander.hpp"
#include "WatchTaskGroupCollection.hpp"

#include <vector>
#include <commctrl.h>

class FWatchSettingDlg {
private:
	FWatchSettingDlg( const FWatchSettingDlg& ); //<! Ȃ
	void operator=( const FWatchSettingDlg& ); //<! Ȃ

public:
	FWatchSettingDlg( WatchTaskGroupCollection& v_watchTaskGroup );
	~FWatchSettingDlg();
	void show( HWND hWnd );

private:
	WatchTaskGroupCollection& watchTaskGroupCollection_;

	HWND hDlg_;

	HWND hTree_;
	HTREEITEM hRootItem_;

	HWND hStatus_;

	DialogLayoutExpander layout_;

private:

	/*!
	 * c[ACeƊ֘AÂꂽ̃IuWFNg̏i[B
	 */
	struct ItemData
	{
		/*!
		 * IuWFNg̃^Cv
		 */
		enum ItemType
		{
			itemtype_root = 0,
			itemtype_group = 1,
			itemtype_task = 2,
		} itemType;

		/*!
		 * itemTypeŎIuWFNgɑ΂郊Xił邩?
		 */
		enum ListenerType
		{
			listenertype_none = 0,
			listenertype_eventlistener = 1,
		} listenerType;

		/*!
		 * ̂ւ̃|C^
		 */
		struct
		{
			WatchTaskGroupCollection* pWatchTaskGroupCollection;
			WatchTaskGroup* pWatchTaskGroup;
			WatchTask* pWatchTask;
			EventListener* pEventListener;
		} ptr;
	};

	typedef std::vector<ItemData> ItemDataList;

	/*!
	 * ̃IuWFNg̏i[zB
	 * z̃CfbNXƃc[ACe(̃[Uf[^)֘AÂB
	 * ̂폜ꂽꍇłAz̃CfbNXύXĂ͂ȂȂ߁A̔z͒ǋLI[łB
	 */
	ItemDataList itemDataList_;

	void onInitDialog();
	void makeTree() throw();

	BOOL onCommand( UINT btn ) throw();
	BOOL onNotify( WPARAM wParam, LPARAM lParam ) throw();

	static tstring getTaskCaption( const TaskSettingInfo& v_settingInfo ) throw();
	static tstring getGroupCaption( const ThreadGroupProfile& v_profile ) throw();

	EventDispatcher* getEventDispatcher( const ItemData& v_itemData );

	void onAddTask();
	void onAddEventListener();
	void onAddGroup();

	void onEdit();
	void onEditListener( HTREEITEM v_hTreeItem, ItemData& v_itemData );
	void onEditGroup( HTREEITEM v_hTreeItem, ItemData& v_itemData );
	void onEditTask( HTREEITEM v_hTreeItem,  ItemData& v_itemData );

	void onDelete();
	void onDeleteGroup( HTREEITEM v_hTreeItem, ItemData& v_itemData );
	void onDeleteTask( HTREEITEM v_hTreeItem,  ItemData& v_itemData );
	void onDeleteListener( HTREEITEM v_hTreeItem,  ItemData& v_itemData );

	void onSaveAsConfig();
	void onSizing( WPARAM wParam, LPARAM lParam );
	void onSize( WPARAM wParam, LPARAM lParam );

	void onSelectChanged( LPNMTREEVIEW pnmtv ) throw();

	void displayStatus() const;

	HIMAGELIST hImageList_;

	static INT_PTR CALLBACK DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
};

#endif
