#include "stdafx.hpp"

#include "PatternMatch.hpp"
#include "tstringUty.hpp"

SimplePatternMatch::SimplePatternMatch( const tstring& v_pattern )
	: pattern_( v_pattern )
{
}

SimplePatternMatch::SimplePatternMatch( const SimplePatternMatch& v_other )
	: pattern_( v_other.pattern_ )
{
}

SimplePatternMatch::~SimplePatternMatch() throw()
{
}

bool SimplePatternMatch::isMatch( const tstring& v_text ) const throw()
{
	return tstringuty::isMatch( v_text, pattern_ );
}

PatternMatch* SimplePatternMatch::clone() const throw()
{
	return new SimplePatternMatch( *this );
}

//////////////////////////////


PatternMatchCollection::PatternMatchCollection( const bool v_allMatch )
	: allMatch_( v_allMatch )
{
}

PatternMatchCollection::PatternMatchCollection( const PatternMatchCollection& v_other)
	: allMatch_ ( v_other.allMatch_ )
{
	for( PatternMatchList::const_iterator ite_patterns = v_other.patterns_.begin();
		ite_patterns != v_other.patterns_.end();
		++ite_patterns
		)
	{
		const PatternMatch* pPatternMatch = *ite_patterns;
		patterns_.push_back( pPatternMatch->clone() );
	}
}

PatternMatchCollection::~PatternMatchCollection() throw()
{
	for( PatternMatchList::iterator ite_patterns = patterns_.begin();
		ite_patterns != patterns_.end();
		++ite_patterns
		)
	{
		delete *ite_patterns;
	}
	patterns_.clear();
}

bool PatternMatchCollection::isMatch( const tstring& v_text ) const throw()
{
	for( PatternMatchList::const_iterator ite_patterns = patterns_.begin();
		ite_patterns != patterns_.end();
		++ite_patterns
		)
	{
		const PatternMatch* pPatternMatch = *ite_patterns;
		const bool result = pPatternMatch->isMatch( v_text );
		if( allMatch_ && ! result ) {
			return false;
		}
		if( ! allMatch_ && result ) {
			return true;
		}
	}
	return allMatch_;
}

PatternMatch* PatternMatchCollection::clone() const throw()
{
	return new PatternMatchCollection( *this );
}

void PatternMatchCollection::addPattern( const PatternMatch& v_pattern ) throw()
{
	patterns_.push_back( v_pattern.clone() );
}

size_t PatternMatchCollection::size() const throw()
{
	return patterns_.size();
}
