#ifndef INCLUDE_H_PATTERNMATCH
#define INCLUDE_H_PATTERNMATCH

#include "tstring.hpp"

#include <list>

class PatternMatch
{
public:
	virtual ~PatternMatch() throw() {};
	
	virtual bool isMatch( const tstring& v_text ) const throw() = 0;
	virtual PatternMatch* clone() const throw() = 0;
};

class SimplePatternMatch : public PatternMatch
{
private:
	void operator=( const SimplePatternMatch& ); //<! Ȃ

protected:
	SimplePatternMatch( const SimplePatternMatch& v_other );

public:
	SimplePatternMatch( const tstring& v_pattern );
	virtual ~SimplePatternMatch() throw();

	virtual bool isMatch( const tstring& v_text ) const throw();
	virtual PatternMatch* clone() const throw();

protected:
	const tstring pattern_;
};

class PatternMatchCollection : public PatternMatch
{
private:
	void operator=( const PatternMatchCollection& ); //<! Ȃ

protected:
	PatternMatchCollection( const PatternMatchCollection& v_other);

public:
	PatternMatchCollection( const bool v_allMatch );
	virtual ~PatternMatchCollection() throw();
	
	virtual bool isMatch( const tstring& v_text ) const throw();
	virtual PatternMatch* clone() const throw();

	virtual void addPattern( const PatternMatch& v_pattern ) throw();
	size_t size() const throw();

protected:
	typedef std::list<PatternMatch*> PatternMatchList;
	const bool allMatch_;
	PatternMatchList patterns_;
};

#endif
