#ifndef INCLUDE_H_SAXCONTEXTHANDLER
#define INCLUDE_H_SAXCONTEXTHANDLER

#include "SAXAttributes.hpp"

#include "tstring.hpp"

#include <map>

class SAXContentHandler
{
public:
	virtual ~SAXContentHandler() {}
	
	virtual void startDocument() = 0;

	virtual void endDocument() = 0;

	virtual void startPrefixMapping(const tstring&, const tstring& ) = 0;

	virtual void endPrefixMapping(const tstring& ) = 0;

	virtual void startElement(
		const tstring& v_namespace,
		const tstring& v_localName,
		const tstring& v_QName,
		const SAXAttributes& pAttr
		) = 0;

	virtual void endElement(
		const tstring& v_namespace,
		const tstring& v_localName,
		const tstring& v_QName
		) = 0;

	virtual void characters(const tstring& v_chars ) = 0;

	virtual void ignorableWhitespace(const tstring& v_chars ) = 0;

	virtual void processingInstruction( const tstring& , const tstring& ) = 0;

	virtual void skippedEntity( const tstring& ) = 0;

};

#endif
