#include "stdafx.hpp"

#include "SAXParser.hpp"
#include "tstring.hpp"
#include "tstringUty.hpp"

#include <memory>

#include <atlcomcli.h>
#include <msxml2.h>

namespace
{

	class DefaultSAXParser : public SAXParser
	{
	private:
		DefaultSAXParser( const DefaultSAXParser& ); //<! Ȃ
		operator=( const DefaultSAXParser& ); //<! Ȃ
	
	public:
		DefaultSAXParser()
		{
		}
		
		virtual ~DefaultSAXParser()
		{
		}
		
		virtual void parse( const tstring& v_url, SAXContentHandler& v_handler )
		{
			const std::wstring url( tstringuty::getWStdString( v_url ) );

			CComQIPtr<ISAXXMLReader> reader;
			if( FAILED( reader.CoCreateInstance( __uuidof( SAXXMLReader ) ) ) ) {
				throw std::runtime_error( "MSXML Creation Failure!!!" ); //TODO: 悢Ol邱
			}

			CComQIPtr<ISAXContentHandler> saxContentHandler;
			saxContentHandler.Attach( new SAXContentHandlerAdaptor( v_handler ) );
			reader->putContentHandler( saxContentHandler );

			if( FAILED( reader->parseURL( url.c_str() ) ) ) {
				throw std::runtime_error( "MSXML Parsing Failure!!!" ); //TODO: 悢Ol邱
			}
		}
	};
}


SAXParserFactory::SAXParserFactory()
{
}

SAXParserFactory::~SAXParserFactory()
{
}

SAXParserPtr SAXParserFactory::create()
{
	return SAXParserPtr( new DefaultSAXParser() );
}

