#include "stdafx.hpp"

#include "ShellExecActionInvoker.hpp"

#include <assert.h>

#include "StringExpander.hpp"
#include "SplitPath.hpp"

ShellExecActionInvoker::ShellExecActionInvoker( const ExecuteActionSettingInfo& v_executeActionSettingInfo ) throw()
	: AbstractExecuteActionInvoker( v_executeActionSettingInfo )
{
}

ShellExecActionInvoker::~ShellExecActionInvoker() throw()
{
}

bool ShellExecActionInvoker::createProcess( const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw()
{
	//required:
	assert( ! v_absolutePath.empty() && "v_absolutePathɋ͎wł܂B" );
	
	//do:

	if( ! actionSettingInfo_.isAvailable() ){
		return true;
	}

	// sp[^̃Zbg
	SplitPath splitPath( v_absolutePath );	

	PropertyStringExpander expander;
	expander.addProperty( _TEXT("PATH"), v_absolutePath );
	expander.addProperty( _TEXT("DIR"), splitPath.getDirectory() );
	expander.addProperty( _TEXT("NAME"), splitPath.getFile() );
	expander.addProperty( _TEXT("NAMEBODY"), splitPath.getDirectory() );
	expander.addProperty( _TEXT("EXTENSION"), splitPath.getFileExtension() );

//			{"count",strCount},
//			{"spath",strShortName},
//			{"date",strDate},
//			{"time",strTime},
//			{"sdir",strShortDir},

	const tstring appName = expander.expandString( actionSettingInfo_.getAppName() );
	const tstring param = expander.expandString( actionSettingInfo_.getParam() );
	const tstring verb = expander.expandString( actionSettingInfo_.getAction() );
	const tstring appCurrentDir = expander.expandString( actionSettingInfo_.getAppCurrentDir() );

	SHELLEXECUTEINFO execinfo = {0};
	execinfo.cbSize = sizeof(SHELLEXECUTEINFO);
	execinfo.fMask  = SEE_MASK_CONNECTNETDRV | SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS;
	execinfo.hwnd   = NULL; //TODO: SHellhWnd
	execinfo.lpDirectory  = appCurrentDir.c_str();
	execinfo.nShow = actionSettingInfo_.getShowWindow().getShowCommand();
	execinfo.lpVerb = verb.c_str();
	execinfo.lpFile = appName.c_str();
	execinfo.lpParameters = param.c_str();

	// s
	if( ! ::ShellExecuteEx( &execinfo ) ) {
		return false;
	}

	addTraceProcessHandle( execinfo.hProcess );
	return true;
}

tstring ShellExecActionInvoker::getDescription() const throw()
{
	return tstring( _TEXT( "ShellExecute" ) );
}

