#include "stdafx.hpp"

#include "FWatchApp.hpp"
#include "resource.h"

#include "tstringUty.hpp"
#include "Utility.hpp"

#include "ShellInvokeActionSettingDialog.hpp"
#include "SettingInfoFactory.hpp"

#include "shlobj.h"

ShellInvokeActionSettingDialog::ShellInvokeActionSettingDialog( const ExecuteActionSettingInfo& v_settingInfo ) throw()
	: hDlg_( NULL )
	, settingInfo_( v_settingInfo )
{
}

ShellInvokeActionSettingDialog::~ShellInvokeActionSettingDialog() throw()
{
}

bool ShellInvokeActionSettingDialog::show( HWND v_hParent ) throw()
{
	return ::DialogBoxParam(
		pApp->getInstanceHandle(), 
		MAKEINTRESOURCE( IDD_SHELLINVOKEACTIONDIALOG ),
		v_hParent,
		dlgProc,
		reinterpret_cast<LPARAM>( this )
		) == IDOK;
}

const ExecuteActionSettingInfo& ShellInvokeActionSettingDialog::getSettingInfo() const throw()
{
	return settingInfo_;
}

void ShellInvokeActionSettingDialog::onInitDialog() throw()
{
	assert( hDlg_ != NULL );

	hVerb = GetDlgItem( hDlg_, IDC_ACTION );
	assert( hVerb != NULL );
	hApp  = GetDlgItem( hDlg_, IDC_APPNAME );
	assert( hApp != NULL );
	hParam= GetDlgItem( hDlg_, IDC_PARAM );
	assert( hParam != NULL );
	hShowWindow = GetDlgItem( hDlg_, IDC_WINDOWSIZE );
	assert( hShowWindow != NULL );
	hMaxProcess = GetDlgItem( hDlg_, IDC_MAXPROCESS );
	assert( hMaxProcess != NULL );
	hAppCurrentDir = GetDlgItem( hDlg_, IDC_APPCURRENTDIR );
	assert( hAppCurrentDir != NULL );

	// EBhETCY̑I
	SendMessage( hShowWindow, CB_INSERTSTRING, 0, (LPARAM) ShowWindowType::valueOf( 0 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 1, (LPARAM) ShowWindowType::valueOf( 1 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 2, (LPARAM) ShowWindowType::valueOf( 2 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 3, (LPARAM) ShowWindowType::valueOf( 3 ).getDescription().c_str() );
	SendMessage( hShowWindow, CB_INSERTSTRING, 4, (LPARAM) ShowWindowType::valueOf( 4 ).getDescription().c_str() );

	// ANV̑I
	const tstring verbList = pApp->LoadString( IDS_SETTINGMES_VERBLIST );
	
	std::vector<tstring> verbs;
	split( verbList, '|', std::back_insert_iterator<std::vector<tstring> >(verbs) );
	for( std::vector<tstring>::iterator ite_verbs = verbs.begin();
		ite_verbs != verbs.end();
		++ite_verbs
		)
	{
		const tstring& verb = *ite_verbs;
		SendMessage( hVerb, CB_INSERTSTRING, -1, (LPARAM) verb.c_str() );
	}

	// I[gRv[g̐ݒ
	::SHAutoComplete( hApp, SHACF_DEFAULT );

	// _CAOp[^ݒ肵܂B
	setInitialParam();
}

void ShellInvokeActionSettingDialog::setInitialParam()
{
	::SendMessage( hShowWindow, CB_SETCURSEL, settingInfo_.getShowWindow(), 0 );

	setWindowText( hVerb, settingInfo_.getAction() );
	setWindowText( hApp, settingInfo_.getAppName() );
	setWindowText( hParam, settingInfo_.getParam() );
	setWindowText( hMaxProcess, tstringuty::IntToString( settingInfo_.getMaxProcess() ) );
	setWindowText( hAppCurrentDir, settingInfo_.getAppCurrentDir() );
}

void ShellInvokeActionSettingDialog::onOk() throw()
{
	ActionSettingParameter param( settingInfo_.getParameters() );

	param.setParameter( _TEXT("ACTION"),      getWindowText( hVerb  ) );
	param.setParameter( _TEXT("APPLICATION"), getWindowText( hApp   ) );
	param.setParameter( _TEXT("PARAMETER"),   getWindowText( hParam ) );
	param.setParameter( _TEXT("MAX_PROCESS"), getWindowText( hMaxProcess ) );
	param.setParameter( _TEXT("CURRENT_DIR"), getWindowText( hAppCurrentDir ) );

	LRESULT nShowWindow;
	if( ( nShowWindow = SendMessage( hShowWindow, CB_GETCURSEL, 0, 0 ) ) == CB_ERR ) {
		nShowWindow = 1;
	}
	param.setParameter( _TEXT("SHOW_WINDOW"), tstringuty::ToString(_TEXT("%d"), nShowWindow) );

	settingInfo_ = ExecuteActionSettingInfo( param );

	EndDialog( hDlg_, IDOK );
}

void ShellInvokeActionSettingDialog::onCancel() throw()
{
	EndDialog( hDlg_, IDCANCEL );
}

void ShellInvokeActionSettingDialog::onSelectApp() throw()
{
	IMalloc* pMalloc = NULL;
	if( FAILED( ::SHGetMalloc( &pMalloc ) ) ) {
		pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_SHELLALLOCERROR );
		return;
	}
	TCHAR InitDir[MAX_PATH] = { 0 };
	LPITEMIDLIST itemidlist;
	if( ::SHGetSpecialFolderLocation( hDlg_, CSIDL_STARTMENU, &itemidlist ) == NOERROR ) {
		::SHGetPathFromIDList( itemidlist, InitDir );
		pMalloc->Free(itemidlist);
	}
	pMalloc->Release();
	pMalloc = NULL;

	tstring filter = pApp->LoadString( IDS_SETTINGMES_OPENFILEFILTER );
	tstring::size_type pos;
	while( ( pos = filter.find( '|' ) ) != tstring::npos ) {
		filter.replace( pos, 1, 1, '\0' );
	}
	filter.push_back( '\0' );

	TCHAR openname[MAX_PATH] = { 0 };
	OPENFILENAME ofn = {0};
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg_;
	ofn.hInstance = pApp->getInstanceHandle();
	ofn.lpstrFilter = filter.data();
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = openname;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrInitialDir = InitDir;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
	if( ::GetOpenFileName( &ofn ) ) {
		setWindowText( hApp, openname );
	}
}

void ShellInvokeActionSettingDialog::onBrowseAppCurDir() throw()
{
	IMalloc* pMalloc = NULL;
	if( FAILED( ::SHGetMalloc( &pMalloc ) ) ) {
		pApp->showMessageBox( MB_ICONERROR | MB_OK, NULL, IDS_MAINPROC_SHELLALLOCERROR );
		return;
	}

	const tstring caption = pApp->LoadString( IDS_SETTINGMES_SELECTDIR );
	
	TCHAR dirname[MAX_PATH];

	BROWSEINFO bi = {0};
	bi.hwndOwner = hDlg_;
	bi.pidlRoot = NULL;
	bi.pszDisplayName = dirname;
	bi.lpszTitle = caption.c_str();
	bi.ulFlags = BIF_RETURNONLYFSDIRS;
	bi.lpfn = NULL;
	bi.lParam = NULL;
	bi.iImage = 0;
	LPITEMIDLIST pidlist = ::SHBrowseForFolder( &bi );
	if( pidlist ){
		if( ::SHGetPathFromIDList( pidlist, dirname ) ) {
			TrimSpaceBothBuff( dirname );
			EnsureEndsWithBuff( dirname, _TEXT("\\") );
			setWindowText( hAppCurrentDir, dirname );
		}
		pMalloc->Free( pidlist );
	}
	pMalloc->Release();
	pMalloc = NULL;
}


BOOL ShellInvokeActionSettingDialog::onCommand( UINT v_id ) throw()
{
	switch( v_id ) 
	{
	case IDOK:
		onOk();
		return TRUE;

	case IDCANCEL:
		onCancel();
		return TRUE;

	case IDC_OPEN:
		onSelectApp();
		return TRUE;

	case IDC_BROWSE_APPCURRENTDIR:
		onBrowseAppCurDir();
		return TRUE;

	default:
		break;
	}

	return FALSE;
}

INT_PTR CALLBACK ShellInvokeActionSettingDialog::dlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam ) throw()
{
#pragma warning( push )
#pragma warning( disable : 4312 4244 )

	ShellInvokeActionSettingDialog* me = reinterpret_cast<ShellInvokeActionSettingDialog*>( ::GetWindowLongPtr( hDlg, DWLP_USER ) );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( uMsg == WM_INITDIALOG ) {
		me = (ShellInvokeActionSettingDialog*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, reinterpret_cast<LONG_PTR>( me ) );
		me->hDlg_ = hDlg;
		me->onInitDialog();
		return TRUE;
	}
	else if( uMsg == WM_COMMAND ) {
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		return me->onCommand( LOWORD(wParam) );
	}

	return FALSE;

#pragma warning( pop )
}

