#include "stdafx.hpp"

#include "SplitPath.hpp"
#include "tstringUty.hpp"

SplitPath::SplitPath()
{
}

SplitPath::SplitPath( const tstring& v_path )
{
	setPath( v_path );
}

SplitPath::~SplitPath()
{
}

void SplitPath::setPath( const tstring& v_path )
{
	dir_.clear();
	file_.clear();
	fileNoExtension_.clear();
	fileExtension_.clear();

	tstring path = tstringuty::trimSpaceBoth( v_path );

	const tstring::size_type len = path.length();
	tstring::size_type lastPos = tstring::npos;
	for( tstring::size_type idx = 0; idx < len; ) {
		if( path[ idx ] == '\\' || path[ idx ] == '/' ) {
			lastPos = idx;
		}
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( path[ idx ] ) ) {
			idx++;
		}
#endif
		idx++;
	}

	tstring file;
	if( lastPos == tstring::npos ) {
		// tH_؂Ȃ
		file = path;
	}
	else {
		dir_ = path.substr( 0, lastPos + 1 );
		if( lastPos + 1 < len ) {
			file = path.substr( lastPos + 1 );
		}
	}

	setFile( file );
}

void SplitPath::setDirectory( const tstring& v_directory )
{
	dir_ = tstringuty::trimSpaceBoth( v_directory );
	if( ! dir_.empty() ) {
		dir_ = tstringuty::ensureEndsWith( dir_, tstring( _TEXT("\\") ) );
	}
}

void SplitPath::setFile( const tstring& v_file )
{
	tstring file = tstringuty::trimSpaceBoth( v_file );

	const tstring::size_type len = file.length();
	tstring::size_type lastPos = tstring::npos;

	for( tstring::size_type idx = 0; idx < len; ) {
		if( file[ idx ] == '\\' || file[ idx ] == '/' ) {
			// t@C/܂܂ꍇ̓LZÃ݂tH_ǉsetPathƓƂB
			// setPath̓t@C̕؂očĂсÅ֐Ăяo܂B
			if( idx == 0 && ! dir_.empty() ) {
				// t@C̐擪u\\vłAtH_łȂ΁u\\v菜Č
				setPath( dir_ + file.substr( 1 ) );
			}
			else {
				setPath( dir_ + file );
			}
			return;
		}
		if( file[ idx ] == '.' ) {
			lastPos = idx;
		}
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( file[ idx ] ) ) {
			idx++;
		}
#endif
		idx++;
	}

	if( lastPos == tstring::npos || lastPos == 0 ) {
		// gqȂ
		// Ṓu.v擪łΊgqł͂ȂAt@CƂ݂Ȃ܂B
		file_ = file;
		fileNoExtension_ = file;
		fileExtension_.clear();
	}
	else {
		if( lastPos + 1 < len ) {
			file_ = file;
			fileNoExtension_ = file.substr( 0, lastPos );
			fileExtension_ = file.substr( lastPos + 1 );
		}
		else {
			file_ = file.substr( 0, lastPos );
			fileNoExtension_ = file_;
			fileExtension_.clear();
		}
	}
}

void SplitPath::setFileExtension( const tstring& v_fileExtension )
{
	tstring extension = tstringuty::trimSpaceBoth( v_fileExtension );
	if( extension.empty() ) {
		fileExtension_.clear();
	}
	else {
		if( extension[ 0 ] == '.' ) {
			// 擪u.vłΒPɃt@CČĂяoB
			setFile( fileNoExtension_ + extension );
		}
		else {
			// 擪u.vłȂΌ݂̃t@CɁu.vČĂяo
			setFile( fileNoExtension_ + _TEXT(".") + extension );
		}
	}
}

tstring SplitPath::getPath() const
{
	return dir_ + file_;
}

const tstring& SplitPath::getDirectory() const
{
	return dir_;
}

const tstring& SplitPath::getFile() const
{
	return file_;
}

const tstring& SplitPath::getFileNoExtension() const
{
	return fileNoExtension_;
}

const tstring& SplitPath::getFileExtension() const
{
	return fileExtension_;
}
