#include "stdafx.hpp"

#include "ThreadGroupProfile.hpp"

ThreadGroupProfile::ThreadGroupProfile( DWORD v_baseCycleSpan )
	: baseCycleSpan_( v_baseCycleSpan )
{
}

ThreadGroupProfile::ThreadGroupProfile( const ThreadGroupProfile& v_other )
	: baseCycleSpan_( v_other.baseCycleSpan_ )
{
}

ThreadGroupProfile& ThreadGroupProfile::operator=( const ThreadGroupProfile& v_other )
{
	if( this != &v_other ) {
		baseCycleSpan_ = v_other.baseCycleSpan_;
	}
	return *this;
}

ThreadGroupProfile::~ThreadGroupProfile()
{
}

void ThreadGroupProfile::setBaseCycleSpan( const DWORD v_baseCycleSpan )
{
	baseCycleSpan_ = ( v_baseCycleSpan > 1 ) ? v_baseCycleSpan : 1;
}

bool ThreadGroupProfile::operator==( const ThreadGroupProfile& v_other ) const
{
	return baseCycleSpan_ == v_other.baseCycleSpan_;
}

bool ThreadGroupProfile::operator!=( const ThreadGroupProfile& v_other ) const
{
	return ! operator==( v_other );
}

